/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.gui.GuiKnowledge;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.particle.ParticleGhost;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSounds;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static final KeyBinding keybindKnowledge = new KeyBinding(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.field_197958_a, "Corail Tombstone");
    private static boolean isGhostlyRender;
    private static boolean hasTrueSight;
    private static boolean isFirstGuiGameOver;
    private static boolean requireRemovalNightVision;
    private static boolean requireRemovalVisibility;
    private static boolean delayedGui;
    private static long nextGhostTime;

    @SubscribeEvent
    public static void onCommandEvent(CommandEvent event) {
        if ("/tbgui".equals(event.getParseResults().getReader().getString())) {
            delayedGui = true;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onRenderCreatureEvent(RenderLivingEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (hasTrueSight && EntityHelper.isValidPlayer((PlayerEntity)mc.field_71439_g) && event.getEntity().func_98034_c((PlayerEntity)mc.field_71439_g)) {
            event.getEntity().func_82142_c(false);
            requireRemovalVisibility = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderCreatureEvent(RenderLivingEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (requireRemovalVisibility) {
            event.getEntity().func_82142_c(true);
            requireRemovalVisibility = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerTickEvent(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.side == LogicalSide.SERVER || !EntityHelper.isValidPlayer((PlayerEntity)mc.field_71439_g)) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            boolean bl = hasTrueSight = EntityHelper.isPotionActive((LivingEntity)mc.field_71439_g, ModEffects.ghostly_shape, 4) || EntityHelper.isPotionActive((LivingEntity)mc.field_71439_g, ModEffects.true_sight);
            if (hasTrueSight && !EntityHelper.isPotionActive((LivingEntity)mc.field_71439_g, Effects.field_76439_r)) {
                mc.field_71439_g.func_195064_c(new EffectInstance(Effects.field_76439_r, 1200, 0, true, false));
                requireRemovalNightVision = true;
            }
            return;
        }
        if (requireRemovalNightVision) {
            mc.field_71439_g.func_184596_c(Effects.field_76439_r);
            requireRemovalNightVision = false;
        }
        if ((keybindKnowledge.func_151468_f() || delayedGui) && (mc.field_71462_r == null || mc.field_71462_r instanceof ChatScreen)) {
            mc.field_71439_g.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                delayedGui = false;
                mc.func_147108_a((Screen)new GuiKnowledge((ITBCapability)cap));
            });
        }
        if (((Boolean)ConfigTombstone.client.enableHalloweenEffect.get()).booleanValue() && Helper.isDateAroundHalloween()) {
            if (Helper.isNight((World)mc.field_71441_e)) {
                long time = mc.field_71441_e.func_82737_E();
                if (nextGhostTime == -1L || time > nextGhostTime) {
                    if (nextGhostTime > -1L && EntityHelper.canPray((PlayerEntity)mc.field_71439_g)) {
                        BlockPos pos = mc.field_71439_g.func_180425_c().func_177982_a(Helper.getRandom(-9, 9), 0, Helper.getRandom(-9, 9));
                        mc.field_71452_i.func_78873_a((Particle)new ParticleGhost((World)mc.field_71441_e, pos));
                        mc.field_71441_e.func_217410_a(new LightningBoltEntity((World)mc.field_71441_e, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true));
                        mc.field_71441_e.func_184156_a(pos, Helper.getRandom(0, 3) == 0 ? ModSounds.GHOST_LAUGH : ModSounds.GHOST_HOWL, SoundCategory.VOICE, 1.0f, 1.0f, true);
                    }
                    nextGhostTime = time + (long)Helper.getRandom(60, 6000);
                }
            } else {
                nextGhostTime = -1L;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpened(GuiOpenEvent event) {
        ClientPlayerEntity player;
        if (event.getGui() instanceof DeathScreen && ((Boolean)ConfigTombstone.client.skipRespawnScreen.get()).booleanValue() && (player = Minecraft.func_71410_x().field_71439_g) != null && !player.field_70170_p.func_72912_H().func_76093_s()) {
            isFirstGuiGameOver = !isFirstGuiGameOver;
            event.setCanceled(true);
            if (!isFirstGuiGameOver) {
                player.func_71004_bE();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (hasTrueSight && event.getInfo().getBlockAtCamera().func_185904_a() == Material.field_151586_h) {
            event.setCanceled(true);
            event.setDensity(event.getDensity() / 4.0f);
            GlStateManager.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderFog(EntityViewRenderEvent.FogColors event) {
        if (hasTrueSight && event.getInfo().getBlockAtCamera().func_185904_a() == Material.field_151586_h) {
            event.setRed(0.09019608f);
            event.setGreen(0.41568628f);
            event.setBlue(0.9254902f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderBlockLayer(RenderBlockOverlayEvent event) {
        if (hasTrueSight && event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiRender(GuiScreenEvent.DrawScreenEvent event) {
        if (requireRemovalNightVision) {
            Minecraft.func_71410_x().field_71439_g.func_184596_c(Effects.field_76439_r);
            requireRemovalNightVision = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleTooltip(ItemTooltipEvent event) {
        if (SupportMods.canDisplayTooltipOnEnchant() && event.getEntityPlayer() != null && event.getEntityPlayer().field_70170_p != null && ((Boolean)ConfigTombstone.client.showInfoOnEnchantment.get()).booleanValue() && event.getItemStack().func_77973_b() == Items.field_151134_bR && event.getItemStack().func_77942_o()) {
            Helper.getTombstoneEnchantments(event.getItemStack()).forEach(enchant -> IntStream.range(0, event.getToolTip().size()).filter(line -> {
                ITextComponent currentTooltip = (ITextComponent)event.getToolTip().get(line);
                return currentTooltip instanceof TranslationTextComponent && enchant.func_77320_a().equals(((TranslationTextComponent)currentTooltip).func_150268_i());
            }).findFirst().ifPresent(line -> {
                List<String> infos = ((TombstoneEnchantment)((Object)enchant)).getTooltipInfos(event.getItemStack());
                for (String info : infos) {
                    event.getToolTip().add(++line, new StringTextComponent(info));
                }
            }));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        boolean bl = isGhostlyRender = EntityHelper.isPotionActive((LivingEntity)player, ModEffects.ghostly_shape) || EntityHelper.getPotionDuration((LivingEntity)player, ModEffects.unstable_intangibleness) % 100 > 79;
        if (isGhostlyRender) {
            GlStateManager.Profile.TRANSPARENT_MODEL.func_187373_a();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        if (isGhostlyRender) {
            GlStateManager.Profile.TRANSPARENT_MODEL.func_187374_b();
        }
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        Location location;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0 || !((Boolean)ConfigTombstone.client.highlight.get()).booleanValue()) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.field_70170_p == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == ModItems.grave_key) {
            location = ModItems.grave_key.getTombPos(stack);
        } else if (stack.func_77973_b() == ModItems.tablet_of_recall) {
            location = ModItems.tablet_of_recall.getTombPos(stack);
        } else if (ModItems.lost_tablet.isWakeUp(stack)) {
            location = ModItems.lost_tablet.getStructurePos(stack);
        } else {
            return;
        }
        if (location.isOrigin() || location.dim != player.field_70170_p.field_73011_w.func_186058_p().func_186068_a() || !World.func_175701_a((BlockPos)location.getPos())) {
            return;
        }
        if (Helper.getDistance((Vec3i)location.getPos(), (Vec3i)player.func_180425_c().func_177984_a()) > 200.0) {
            Vec3d vec = new Vec3d((Vec3i)location.getPos()).func_178788_d(player.func_174791_d()).func_72432_b();
            location.x = (int)(player.func_174791_d().field_72450_a + vec.field_72450_a * 200.0);
            location.y = (int)(player.func_174791_d().field_72448_b + vec.field_72448_b * 200.0);
            location.z = (int)(player.func_174791_d().field_72449_c + vec.field_72449_c * 200.0);
        }
        double posEye = player.func_213307_e(player.func_213283_Z());
        double doubleX = MathHelper.func_219803_d((double)event.getPartialTicks(), (double)player.field_70142_S, (double)player.field_70165_t);
        double doubleY = MathHelper.func_219803_d((double)event.getPartialTicks(), (double)(player.field_70137_T + posEye), (double)(player.field_70163_u + posEye));
        double doubleZ = MathHelper.func_219803_d((double)event.getPartialTicks(), (double)player.field_70136_U, (double)player.field_70161_v);
        GlStateManager.pushMatrix();
        GlStateManager.disableTexture();
        GlStateManager.disableLighting();
        GlStateManager.translated((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        long c = TimeHelper.systemTime() / 15L % 360L;
        float[] color = Helper.getHSBtoRGBF((float)c / 360.0f, 1.0f, 1.0f);
        float x = location.x;
        float y = location.y;
        float z = location.z;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        GlStateManager.color4f((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        GL11.glLineWidth((float)2.5f);
        GlStateManager.pushLightingAttributes();
        GL11.glDisable((int)2929);
        float offset = 1.0f;
        renderer.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)(z + offset)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.popAttributes();
        GlStateManager.enableTexture();
        GlStateManager.enableLighting();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    static {
        ClientRegistry.registerKeyBinding((KeyBinding)keybindKnowledge);
        isGhostlyRender = false;
        hasTrueSight = false;
        isFirstGuiGameOver = false;
        requireRemovalNightVision = false;
        requireRemovalVisibility = false;
        delayedGui = false;
        nextGhostTime = -1L;
    }
}

