/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus.world;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.quetzi.morpheus.helpers.Config;

public class WorldSleepState {
    private int dimension;
    private HashMap<String, Boolean> playerStatus;

    public WorldSleepState(int dimension) {
        this.dimension = dimension;
        this.playerStatus = new HashMap();
    }

    public int getPercentSleeping() {
        return this.playerStatus.size() - this.getMiningPlayers() - this.getSpectators() > 0 ? (this.getSleepingPlayers() > 0 ? this.getSleepingPlayers() * 100 / (this.playerStatus.size() - this.getMiningPlayers() - this.getSpectators()) : 0) : 100;
    }

    private int getMiningPlayers() {
        int miningPlayers = 0;
        for (PlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            if (player.field_71093_bK.func_186068_a() != this.dimension || !(player.field_70163_u < (double)((Integer)Config.SERVER.groundLevel.get()).intValue())) continue;
            ++miningPlayers;
        }
        return (Boolean)Config.SERVER.includeMiners.get() != false ? miningPlayers : 0;
    }

    private int getSpectators() {
        int spectators = 0;
        for (PlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            if (!player.func_175149_v() && !player.func_184812_l_()) continue;
            ++spectators;
        }
        return spectators;
    }

    public int getSleepingPlayers() {
        int asleepCount = 0;
        for (Map.Entry<String, Boolean> entry : this.playerStatus.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            ++asleepCount;
        }
        return asleepCount;
    }

    public String toString() {
        return (Boolean)Config.SERVER.includeMiners.get() == false ? this.getSleepingPlayers() + "/" + this.playerStatus.size() + " (" + this.getPercentSleeping() + "%)" : this.getSleepingPlayers() + "/" + this.playerStatus.size() + " - " + this.getMiningPlayers() + " miners (" + this.getPercentSleeping() + "%)";
    }

    public void setPlayerAsleep(String username) {
        this.playerStatus.put(username, true);
    }

    public void setPlayerAwake(String username) {
        this.playerStatus.put(username, false);
    }

    public boolean isPlayerSleeping(String username) {
        if (this.playerStatus.containsKey(username)) {
            return this.playerStatus.get(username);
        }
        this.playerStatus.put(username, false);
        return false;
    }

    public void removePlayer(String username) {
        this.playerStatus.remove(username);
    }

    public void wakeAllPlayers() {
        for (Map.Entry<String, Boolean> entry : this.playerStatus.entrySet()) {
            entry.setValue(false);
        }
    }
}

