/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public final class BiomeUtils {
    private static final Pattern CATEGORY_PATTERN = Pattern.compile("#", 16);

    private BiomeUtils() {
    }

    public static boolean matches(Biome biome, String input) {
        if (biome == BiomeUtils.from(input)) {
            return true;
        }
        String category = CATEGORY_PATTERN.matcher(input).replaceFirst(Matcher.quoteReplacement(""));
        return biome.func_201856_r().name().equalsIgnoreCase(category);
    }

    public static boolean containedInList(Biome biome, Collection<? extends String> list, boolean valueIfListEmpty) {
        if (list.isEmpty()) {
            return valueIfListEmpty;
        }
        for (String string : list) {
            if (!BiomeUtils.matches(biome, string)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Biome from(String str) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)str);
        if (id != null) {
            return (Biome)ForgeRegistries.BIOMES.getValue(id);
        }
        return null;
    }
}

