/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.client.render;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.silentchaos512.lib.client.model.ILayeredBakedModel;
import net.silentchaos512.lib.item.ICustomEnchantColor;

@ParametersAreNonnullByDefault
public class TEISRCustomEnchantedEffect
extends ItemStackTileEntityRenderer {
    public static final TEISRCustomEnchantedEffect INSTANCE = new TEISRCustomEnchantedEffect();
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final ImmutableSet<Direction> EMPTY = ImmutableSet.of();
    private static final ImmutableSet<Direction> STUPID_FACES = ImmutableSet.of((Object)Direction.SOUTH, (Object)Direction.NORTH);
    private static final Random RANDOM = new Random();

    private TEISRCustomEnchantedEffect() {
    }

    public void func_179022_a(ItemStack stack) {
        int i;
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
        if (!(model instanceof ILayeredBakedModel)) {
            throw new IllegalArgumentException("Model must be a ILayeredBakedModel");
        }
        int effectColor = this.getEffectColor(stack);
        int layerCount = ((ILayeredBakedModel)model).getLayerCount();
        for (i = 0; i < layerCount; ++i) {
            this.renderModelExcluding(model, -1, stack, i, (Collection<Direction>)EMPTY);
        }
        if (stack.func_77962_s()) {
            this.renderEffectExcluding(model, effectColor, 0, (Collection<Direction>)EMPTY);
            for (i = 1; i < layerCount; ++i) {
                this.renderEffectExcluding(model, effectColor, i, (Collection<Direction>)STUPID_FACES);
            }
        }
    }

    private int getEffectColor(ItemStack stack) {
        int effectColor = 8405196;
        if (stack.func_77973_b() instanceof ICustomEnchantColor) {
            int maxBrightness;
            int b;
            int g;
            int r;
            int total;
            ICustomEnchantColor item = (ICustomEnchantColor)stack.func_77973_b();
            effectColor = item.getEffectColor(stack);
            if (item.shouldTruncateBrightness(stack) && (total = (r = effectColor >> 16 & 0xFF) + (g = effectColor >> 8 & 0xFF) + (b = effectColor & 0xFF)) > (maxBrightness = item.getEffectMaxBrightness(stack))) {
                float scale = (float)maxBrightness / (float)total;
                r = (int)((float)r * scale);
                g = (int)((float)g * scale);
                b = (int)((float)b * scale);
                effectColor = (r << 16) + (g << 8) + b;
            }
        }
        return effectColor;
    }

    private void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1 && !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    private void renderEffectExcluding(IBakedModel model, int effectColor, int layerIndex, Collection<Direction> excludeFaces) {
        int color = effectColor | 0xFF000000;
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.depthFunc((int)514);
        GlStateManager.disableLighting();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        textureManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.matrixMode((int)5890);
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Util.func_211177_b() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.translatef((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModelExcluding(model, color, layerIndex, excludeFaces);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Util.func_211177_b() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.translatef((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModelExcluding(model, color, layerIndex, excludeFaces);
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.enableLighting();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        textureManager.func_110577_a(AtlasTexture.field_110575_b);
    }

    private void renderModelExcluding(IBakedModel model, int color, int layerIndex, Collection<Direction> excludeFaces) {
        this.renderModelExcluding(model, color, ItemStack.field_190927_a, layerIndex, excludeFaces);
    }

    private void renderModelExcluding(IBakedModel model, int color, ItemStack stack, int layerIndex, Collection<Direction> excludeFaces) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (layerIndex < 0) {
            for (int i = 0; i < ((ILayeredBakedModel)model).getLayerCount(); ++i) {
                for (BakedQuad quad : model.func_200117_a(null, null, RANDOM)) {
                    if (excludeFaces.contains(quad.func_178210_d())) continue;
                    quads.add(quad);
                }
            }
        } else {
            for (BakedQuad quad : model.func_200117_a(null, null, RANDOM)) {
                if (excludeFaces.contains(quad.func_178210_d())) continue;
                quads.add(quad);
            }
        }
        this.renderQuads(bufferbuilder, quads, color, stack);
        tessellator.func_78381_a();
    }
}

