/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.worldgen;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.init.BPBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockStoneOre
extends Block {
    private String name;
    private boolean transparent = false;
    private boolean witherproof = false;
    private String[] tooltip = new String[0];

    public BlockStoneOre(String name) {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(5.0f).func_200947_a(SoundType.field_185851_d));
        this.name = name;
        this.setRegistryName("bluepower", name);
        BPBlocks.blockList.add(this);
    }

    public BlockStoneOre(String name, Block.Properties properties) {
        super(properties);
        this.name = name;
        this.setRegistryName("bluepower", name);
        BPBlocks.blockList.add(this);
    }

    public boolean isBeaconBase(BlockState state, IWorldReader world, BlockPos pos, BlockPos beacon) {
        return this == BPBlocks.amethyst_block || this == BPBlocks.ruby_block || this == BPBlocks.malachite_block || this == BPBlocks.sapphire_block || this == BPBlocks.copper_block || this == BPBlocks.zinc_block || this == BPBlocks.silver_block || this == BPBlocks.tungsten_block;
    }

    public BlockStoneOre setTransparent(boolean transparent) {
        this.transparent = transparent;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.transparent ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.transparent ? 0 : super.func_200011_d(state, worldIn, pos);
    }

    public BlockStoneOre setWitherproof(boolean witherproof) {
        this.witherproof = witherproof;
        return this;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (this.witherproof) {
            tooltip.add((ITextComponent)new StringTextComponent(MinecraftColor.RED.getChatColor() + "Witherproof"));
        }
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        if (this.witherproof) {
            return !(entity instanceof WitherEntity) && super.canEntityDestroy(state, world, pos, entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!this.witherproof) {
            super.func_180652_a(worldIn, pos, explosionIn);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return !this.witherproof && super.func_149659_a(explosion);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        drops.add(new ItemStack((IItemProvider)this));
        return drops;
    }
}

