/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidAttributes;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModelFluid
implements IUnbakedModel {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ModelFluid WATER = new ModelFluid((Fluid)Fluids.field_204546_a);
    public static final ModelFluid LAVA = new ModelFluid((Fluid)Fluids.field_204547_b);
    private final Fluid fluid;

    public ModelFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        FluidAttributes attrs = this.fluid.getAttributes();
        return attrs.getOverlayTexture() != null ? ImmutableSet.of((Object)attrs.getStillTexture(), (Object)attrs.getFlowingTexture(), (Object)attrs.getOverlayTexture()) : ImmutableSet.of((Object)attrs.getStillTexture(), (Object)attrs.getFlowingTexture());
    }

    public Collection<ResourceLocation> func_187965_e() {
        return Collections.emptyList();
    }

    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        FluidAttributes attrs = this.fluid.getAttributes();
        return new CachingBakedFluid(sprite.getState().apply(Optional.empty()), PerspectiveMapWrapper.getTransforms(sprite.getState()), format, attrs.getColor(), spriteGetter.apply(attrs.getStillTexture()), spriteGetter.apply(attrs.getFlowingTexture()), Optional.ofNullable(attrs.getOverlayTexture()).map(spriteGetter), attrs.isLighterThanAir(), null);
    }

    public ModelFluid process(ImmutableMap<String, String> customData) {
        if (!customData.containsKey((Object)"fluid")) {
            return this;
        }
        String fluidStr = (String)customData.get((Object)"fluid");
        JsonElement e = new JsonParser().parse(fluidStr);
        String fluid = e.getAsString();
        return this;
    }

    private static class BakedFluid
    implements IBakedModel {
        private static final int[] x = new int[]{0, 0, 1, 1};
        private static final int[] z = new int[]{0, 1, 1, 0};
        private static final float eps = 0.001f;
        protected final Optional<TRSRTransformation> transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        protected final VertexFormat format;
        protected final int color;
        protected final TextureAtlasSprite still;
        protected final TextureAtlasSprite flowing;
        protected final Optional<TextureAtlasSprite> overlay;
        protected final boolean gas;
        protected final ImmutableMap<Direction, ImmutableList<BakedQuad>> faceQuads;

        public BakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, Optional<TextureAtlasSprite> overlay, boolean gas, boolean statePresent, int[] cornerRound, int flowRound, boolean[] sideOverlays) {
            this.transformation = transformation;
            this.transforms = transforms;
            this.format = format;
            this.color = color;
            this.still = still;
            this.flowing = flowing;
            this.overlay = overlay;
            this.gas = gas;
            this.faceQuads = this.buildQuads(statePresent, cornerRound, flowRound, sideOverlays);
        }

        private ImmutableMap<Direction, ImmutableList<BakedQuad>> buildQuads(boolean statePresent, int[] cornerRound, int flowRound, boolean[] sideOverlays) {
            EnumMap<Direction, ImmutableList> faceQuads = new EnumMap<Direction, ImmutableList>(Direction.class);
            for (Direction side : Direction.values()) {
                faceQuads.put(side, ImmutableList.of());
            }
            if (statePresent) {
                float[] y = new float[4];
                boolean fullVolume = true;
                for (int i2 = 0; i2 < 4; ++i2) {
                    float value = (float)cornerRound[i2] / 864.0f;
                    if (value < 1.0f) {
                        fullVolume = false;
                    }
                    y[i2] = this.gas ? 1.0f - value : value;
                }
                boolean isFlowing = flowRound > -1000;
                float flow = isFlowing ? (float)Math.toRadians(flowRound) : 0.0f;
                TextureAtlasSprite topSprite = isFlowing ? this.flowing : this.still;
                float scale = isFlowing ? 4.0f : 8.0f;
                float c = MathHelper.func_76134_b((float)flow) * scale;
                float s = MathHelper.func_76126_a((float)flow) * scale;
                Direction top = this.gas ? Direction.DOWN : Direction.UP;
                VertexParameter uv = i -> c * (float)(x[i] * 2 - 1) + s * (float)(z[i] * 2 - 1);
                VertexParameter topX = i -> x[i];
                VertexParameter topY = i -> y[i];
                VertexParameter topZ = i -> z[i];
                VertexParameter topU = i -> 8.0f + uv.get(i);
                VertexParameter topV = i -> 8.0f + uv.get((i + 1) % 4);
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)this.buildQuad(top, topSprite, this.gas, false, topX, topY, topZ, topU, topV));
                if (!fullVolume) {
                    builder.add((Object)this.buildQuad(top, topSprite, !this.gas, true, topX, topY, topZ, topU, topV));
                }
                faceQuads.put(top, builder.build());
                Direction bottom = top.func_176734_d();
                faceQuads.put(bottom, ImmutableList.of((Object)this.buildQuad(bottom, this.still, this.gas, false, i -> z[i], i -> this.gas ? 1.0f : 0.0f, i -> x[i], i -> z[i] * 16, i -> x[i] * 16)));
                for (int i3 = 0; i3 < 4; ++i3) {
                    Direction side = Direction.func_176731_b((int)((5 - i3) % 4));
                    boolean useOverlay = this.overlay.isPresent() && sideOverlays[side.func_176736_b()];
                    int si = i3;
                    VertexParameter sideX = j -> x[(si + x[j]) % 4];
                    VertexParameter sideY = j -> z[j] == 0 ? (float)(this.gas ? 1 : 0) : y[(si + x[j]) % 4];
                    VertexParameter sideZ = j -> z[(si + x[j]) % 4];
                    VertexParameter sideU = j -> x[j] * 8;
                    VertexParameter sideV = j -> (this.gas ? sideY.get(j) : 1.0f - sideY.get(j)) * 8.0f;
                    ImmutableList.Builder builder2 = ImmutableList.builder();
                    if (!useOverlay) {
                        builder2.add((Object)this.buildQuad(side, this.flowing, this.gas, true, sideX, sideY, sideZ, sideU, sideV));
                    }
                    builder2.add((Object)this.buildQuad(side, useOverlay ? this.overlay.get() : this.flowing, !this.gas, false, sideX, sideY, sideZ, sideU, sideV));
                    faceQuads.put(side, builder2.build());
                }
            } else {
                faceQuads.put(Direction.SOUTH, ImmutableList.of((Object)this.buildQuad(Direction.UP, this.still, false, false, i -> z[i], i -> x[i], i -> 0.0f, i -> z[i] * 16, i -> x[i] * 16)));
            }
            return ImmutableMap.copyOf(faceQuads);
        }

        private BakedQuad buildQuad(Direction side, TextureAtlasSprite texture, boolean flip, boolean offset, VertexParameter x, VertexParameter y, VertexParameter z, VertexParameter u, VertexParameter v) {
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
            builder.setQuadOrientation(side);
            builder.setTexture(texture);
            builder.setQuadTint(0);
            boolean hasTransform = this.transformation.isPresent() && !this.transformation.get().isIdentity();
            IVertexConsumer consumer = hasTransform ? new TRSRTransformer(builder, this.transformation.get()) : builder;
            for (int i = 0; i < 4; ++i) {
                int vertex = flip ? 3 - i : i;
                this.putVertex(consumer, side, offset, x.get(vertex), y.get(vertex), z.get(vertex), texture.func_94214_a((double)u.get(vertex)), texture.func_94207_b((double)v.get(vertex)));
            }
            return builder.build();
        }

        private void putVertex(IVertexConsumer consumer, Direction side, boolean offset, float x, float y, float z, float u, float v) {
            block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
                switch (this.format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        float dx = offset ? (float)side.func_176730_m().func_177958_n() * 0.001f : 0.0f;
                        float dy = offset ? (float)side.func_176730_m().func_177956_o() * 0.001f : 0.0f;
                        float dz = offset ? (float)side.func_176730_m().func_177952_p() * 0.001f : 0.0f;
                        consumer.put(e, x - dx, y - dy, z - dz, 1.0f);
                        continue block6;
                    }
                    case COLOR: {
                        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
                        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
                        float b = (float)(this.color & 0xFF) / 255.0f;
                        float a = (float)(this.color >> 24 & 0xFF) / 255.0f;
                        consumer.put(e, r, g, b, a);
                        continue block6;
                    }
                    case NORMAL: {
                        float offX = side.func_82601_c();
                        float offY = side.func_96559_d();
                        float offZ = side.func_82599_e();
                        consumer.put(e, offX, offY, offZ, 0.0f);
                        continue block6;
                    }
                    case UV: {
                        if (this.format.func_177348_c(e).func_177369_e() == 0) {
                            consumer.put(e, u, v, 0.0f, 1.0f);
                            continue block6;
                        }
                    }
                    default: {
                        consumer.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.still;
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            return side == null ? ImmutableList.of() : (List)this.faceQuads.get((Object)side);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, type);
        }

        private static interface VertexParameter {
            public float get(int var1);
        }
    }

    private static final class CachingBakedFluid
    extends BakedFluid {
        private final LoadingCache<Long, BakedFluid> modelCache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<Long, BakedFluid>(){

            public BakedFluid load(Long key) {
                boolean statePresent = (key & 1L) != 0L;
                key = key >>> 1;
                int[] cornerRound = new int[4];
                for (int i = 0; i < 4; ++i) {
                    cornerRound[i] = (int)(key & 0x3FFL);
                    key = key >>> 10;
                }
                int flowRound = (int)(key & 0x7FFL) - 1024;
                key = key >>> 11;
                boolean[] overlaySides = new boolean[4];
                for (int i = 0; i < 4; ++i) {
                    overlaySides[i] = (key & 1L) != 0L;
                    key = key >>> 1;
                }
                return new BakedFluid(transformation, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms, format, color, still, flowing, overlay, gas, statePresent, cornerRound, flowRound, overlaySides);
            }
        });

        public CachingBakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, Optional<TextureAtlasSprite> overlay, boolean gas, Optional<IModelData> stateOption) {
            super(transformation, transforms, format, color, still, flowing, overlay, gas, stateOption.isPresent(), CachingBakedFluid.getCorners(stateOption), CachingBakedFluid.getFlow(stateOption), CachingBakedFluid.getOverlay(stateOption));
        }

        private static int[] getCorners(Optional<IModelData> stateOption) {
            int[] cornerRound = new int[]{0, 0, 0, 0};
            if (stateOption.isPresent()) {
                IModelData state = stateOption.get();
                for (int i = 0; i < 4; ++i) {
                    Float level = null;
                    cornerRound[i] = Math.round((level == null ? 0.8888889f : level.floatValue()) * 864.0f);
                }
            }
            return cornerRound;
        }

        private static int getFlow(Optional<IModelData> stateOption) {
            Float flow = Float.valueOf(-1000.0f);
            if (stateOption.isPresent() && (flow = null) == null) {
                flow = Float.valueOf(-1000.0f);
            }
            int flowRound = (int)Math.round(Math.toDegrees(flow.floatValue()));
            flowRound = MathHelper.func_76125_a((int)flowRound, (int)-1000, (int)1000);
            return flowRound;
        }

        private static boolean[] getOverlay(Optional<IModelData> stateOption) {
            boolean[] overlaySides = new boolean[4];
            if (stateOption.isPresent()) {
                IModelData state = stateOption.get();
                for (int i = 0; i < 4; ++i) {
                    Boolean overlay = null;
                    if (overlay == null) continue;
                    overlaySides[i] = overlay;
                }
            }
            return overlaySides;
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
            if (side != null) {
                int i;
                Optional<IModelData> exState = Optional.of(modelData);
                int[] cornerRound = CachingBakedFluid.getCorners(exState);
                int flowRound = CachingBakedFluid.getFlow(exState);
                boolean[] overlaySides = CachingBakedFluid.getOverlay(exState);
                long key = 0L;
                for (i = 3; i >= 0; --i) {
                    key <<= 1;
                    key |= overlaySides[i] ? 1L : 0L;
                }
                key <<= 11;
                key |= (long)(flowRound + 1024);
                for (i = 3; i >= 0; --i) {
                    key <<= 10;
                    key |= (long)cornerRound[i];
                }
                key <<= 1;
                return ((BakedFluid)this.modelCache.getUnchecked((Object)(key |= 1L))).func_200117_a(state, side, rand);
            }
            return super.func_200117_a(state, side, rand);
        }
    }

    public static enum FluidLoader implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("forge") && (modelLocation.func_110623_a().equals("fluid") || modelLocation.func_110623_a().equals("models/block/fluid") || modelLocation.func_110623_a().equals("models/item/fluid"));
        }

        @Override
        public IUnbakedModel loadModel(ResourceLocation modelLocation) {
            return WATER;
        }
    }
}

