/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public interface IEntityReader {
    public List<Entity> func_175674_a(@Nullable Entity var1, AxisAlignedBB var2, @Nullable Predicate<? super Entity> var3);

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> var1, AxisAlignedBB var2, @Nullable Predicate<? super T> var3);

    default public <T extends Entity> List<T> func_225316_b(Class<? extends T> clazz, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super T> predicate) {
        return this.func_175647_a(clazz, axisAlignedBB, predicate);
    }

    public List<? extends PlayerEntity> func_217369_A();

    default public List<Entity> func_72839_b(@Nullable Entity entity, AxisAlignedBB axisAlignedBB) {
        return this.func_175674_a(entity, axisAlignedBB, EntityPredicates.field_180132_d);
    }

    default public boolean func_195585_a(@Nullable Entity entity3, VoxelShape voxelShape) {
        if (voxelShape.func_197766_b()) {
            return true;
        }
        return this.func_72839_b(entity3, voxelShape.func_197752_a()).stream().filter(entity2 -> !entity2.field_70128_L && entity2.field_70156_m && (entity3 == null || !entity2.func_184223_x(entity3))).noneMatch(entity -> VoxelShapes.func_197879_c(voxelShape, VoxelShapes.func_197881_a(entity.func_174813_aQ()), IBooleanFunction.field_223238_i_));
    }

    default public <T extends Entity> List<T> func_217357_a(Class<? extends T> clazz, AxisAlignedBB axisAlignedBB) {
        return this.func_175647_a(clazz, axisAlignedBB, EntityPredicates.field_180132_d);
    }

    default public <T extends Entity> List<T> func_225317_b(Class<? extends T> clazz, AxisAlignedBB axisAlignedBB) {
        return this.func_225316_b(clazz, axisAlignedBB, EntityPredicates.field_180132_d);
    }

    default public Stream<VoxelShape> func_223439_a(@Nullable Entity entity3, AxisAlignedBB axisAlignedBB, Set<Entity> set) {
        if (axisAlignedBB.func_72320_b() < 1.0E-7) {
            return Stream.empty();
        }
        AxisAlignedBB axisAlignedBB2 = axisAlignedBB.func_186662_g(1.0E-7);
        return this.func_72839_b(entity3, axisAlignedBB2).stream().filter(entity -> !set.contains(entity)).filter(entity2 -> entity3 == null || !entity3.func_184223_x((Entity)entity2)).flatMap(entity2 -> Stream.of(entity2.func_70046_E(), entity3 == null ? null : entity3.func_70114_g((Entity)entity2))).filter(Objects::nonNull).filter(axisAlignedBB2::func_72326_a).map(VoxelShapes::func_197881_a);
    }

    @Nullable
    default public PlayerEntity func_190525_a(double d, double d2, double d3, double d4, @Nullable Predicate<Entity> predicate) {
        double d5 = -1.0;
        PlayerEntity \u26032 = null;
        for (PlayerEntity playerEntity : this.func_217369_A()) {
            if (predicate != null && !predicate.test(playerEntity)) continue;
            double d6 = playerEntity.func_70092_e(d, d2, d3);
            if (!(d4 < 0.0) && !(d6 < d4 * d4) || d5 != -1.0 && !(d6 < d5)) continue;
            d5 = d6;
            \u26032 = playerEntity;
        }
        return \u26032;
    }

    @Nullable
    default public PlayerEntity func_217362_a(Entity entity, double d) {
        return this.func_217366_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, d, false);
    }

    @Nullable
    default public PlayerEntity func_217366_a(double d, double d2, double d3, double d4, boolean bl) {
        Predicate<Entity> predicate = bl ? EntityPredicates.field_188444_d : EntityPredicates.field_180132_d;
        return this.func_190525_a(d, d2, d3, d4, predicate);
    }

    @Nullable
    default public PlayerEntity func_217365_a(double d, double d2, double d3) {
        double d4 = -1.0;
        PlayerEntity \u26032 = null;
        for (PlayerEntity playerEntity : this.func_217369_A()) {
            if (!EntityPredicates.field_180132_d.test(playerEntity)) continue;
            double d42 = playerEntity.func_70092_e(d, playerEntity.field_70163_u, d2);
            if (!(d3 < 0.0) && !(d42 < d3 * d3) || d4 != -1.0 && !(d42 < d4)) continue;
            d4 = d42;
            \u26032 = playerEntity;
        }
        return \u26032;
    }

    default public boolean func_217358_a(double d, double d2, double d3, double d4) {
        for (PlayerEntity playerEntity : this.func_217369_A()) {
            if (!EntityPredicates.field_180132_d.test(playerEntity) || !EntityPredicates.field_212545_b.test(playerEntity)) continue;
            double d5 = playerEntity.func_70092_e(d, d2, d3);
            if (!(d4 < 0.0) && !(d5 < d4 * d4)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public PlayerEntity func_217370_a(EntityPredicate entityPredicate, LivingEntity livingEntity) {
        return this.func_217361_a(this.func_217369_A(), entityPredicate, livingEntity, livingEntity.field_70165_t, livingEntity.field_70163_u, livingEntity.field_70161_v);
    }

    @Nullable
    default public PlayerEntity func_217372_a(EntityPredicate entityPredicate, LivingEntity livingEntity, double d, double d2, double d3) {
        return this.func_217361_a(this.func_217369_A(), entityPredicate, livingEntity, d, d2, d3);
    }

    @Nullable
    default public PlayerEntity func_217359_a(EntityPredicate entityPredicate, double d, double d2, double d3) {
        return this.func_217361_a(this.func_217369_A(), entityPredicate, null, d, d2, d3);
    }

    @Nullable
    default public <T extends LivingEntity> T func_217360_a(Class<? extends T> clazz, EntityPredicate entityPredicate, @Nullable LivingEntity livingEntity, double d, double d2, double d3, AxisAlignedBB axisAlignedBB) {
        return this.func_217361_a(this.func_175647_a(clazz, axisAlignedBB, null), entityPredicate, livingEntity, d, d2, d3);
    }

    @Nullable
    default public <T extends LivingEntity> T func_225318_b(Class<? extends T> clazz, EntityPredicate entityPredicate, @Nullable LivingEntity livingEntity, double d, double d2, double d3, AxisAlignedBB axisAlignedBB) {
        return this.func_217361_a(this.func_225316_b(clazz, axisAlignedBB, null), entityPredicate, livingEntity, d, d2, d3);
    }

    @Nullable
    default public <T extends LivingEntity> T func_217361_a(List<? extends T> list, EntityPredicate entityPredicate, @Nullable LivingEntity livingEntity, double d, double d2, double d3) {
        \u2603 = -1.0;
        LivingEntity \u26032 = null;
        for (LivingEntity livingEntity2 : list) {
            if (!entityPredicate.func_221015_a(livingEntity, livingEntity2)) continue;
            double d4 = livingEntity2.func_70092_e(d, d2, d3);
            if (\u2603 != -1.0 && !(d4 < \u2603)) continue;
            \u2603 = d4;
            \u26032 = livingEntity2;
        }
        return (T)\u26032;
    }

    default public List<PlayerEntity> func_217373_a(EntityPredicate entityPredicate, LivingEntity livingEntity, AxisAlignedBB axisAlignedBB) {
        ArrayList arrayList = Lists.newArrayList();
        for (PlayerEntity playerEntity : this.func_217369_A()) {
            if (!axisAlignedBB.func_197744_e(playerEntity.field_70165_t, playerEntity.field_70163_u, playerEntity.field_70161_v) || !entityPredicate.func_221015_a(livingEntity, playerEntity)) continue;
            arrayList.add(playerEntity);
        }
        return arrayList;
    }

    default public <T extends LivingEntity> List<T> func_217374_a(Class<? extends T> clazz, EntityPredicate entityPredicate, LivingEntity livingEntity, AxisAlignedBB axisAlignedBB) {
        List<T> list = this.func_175647_a(clazz, axisAlignedBB, null);
        ArrayList \u26032 = Lists.newArrayList();
        for (LivingEntity livingEntity2 : list) {
            if (!entityPredicate.func_221015_a(livingEntity, livingEntity2)) continue;
            \u26032.add(livingEntity2);
        }
        return \u26032;
    }

    @Nullable
    default public PlayerEntity func_217371_b(UUID uUID) {
        for (int i = 0; i < this.func_217369_A().size(); ++i) {
            PlayerEntity playerEntity = this.func_217369_A().get(i);
            if (!uUID.equals(playerEntity.func_110124_au())) continue;
            return playerEntity;
        }
        return null;
    }
}

