/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.TranslationTextComponent;

public class JsonToNBT {
    public static final SimpleCommandExceptionType field_197657_a = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.nbt.trailing", new Object[0]));
    public static final SimpleCommandExceptionType field_197658_b = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.nbt.expected.key", new Object[0]));
    public static final SimpleCommandExceptionType field_197659_c = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.nbt.expected.value", new Object[0]));
    public static final Dynamic2CommandExceptionType field_197660_d = new Dynamic2CommandExceptionType((object, object2) -> new TranslationTextComponent("argument.nbt.list.mixed", object, object2));
    public static final Dynamic2CommandExceptionType field_197661_e = new Dynamic2CommandExceptionType((object, object2) -> new TranslationTextComponent("argument.nbt.array.mixed", object, object2));
    public static final DynamicCommandExceptionType field_197662_f = new DynamicCommandExceptionType(object -> new TranslationTextComponent("argument.nbt.array.invalid", object));
    private static final Pattern field_193615_a = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern field_193616_b = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern field_193617_c = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern field_193618_d = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern field_193619_e = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern field_193620_f = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern field_193621_g = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private final StringReader field_197663_n;

    public static CompoundNBT func_180713_a(String string) throws CommandSyntaxException {
        return new JsonToNBT(new StringReader(string)).func_193609_a();
    }

    @VisibleForTesting
    CompoundNBT func_193609_a() throws CommandSyntaxException {
        CompoundNBT compoundNBT = this.func_193593_f();
        this.field_197663_n.skipWhitespace();
        if (this.field_197663_n.canRead()) {
            throw field_197657_a.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        return compoundNBT;
    }

    public JsonToNBT(StringReader stringReader) {
        this.field_197663_n = stringReader;
    }

    protected String func_193601_b() throws CommandSyntaxException {
        this.field_197663_n.skipWhitespace();
        if (!this.field_197663_n.canRead()) {
            throw field_197658_b.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        return this.field_197663_n.readString();
    }

    protected INBT func_193611_c() throws CommandSyntaxException {
        this.field_197663_n.skipWhitespace();
        int n = this.field_197663_n.getCursor();
        if (StringReader.isQuotedStringStart((char)this.field_197663_n.peek())) {
            return new StringNBT(this.field_197663_n.readQuotedString());
        }
        String \u26032 = this.field_197663_n.readUnquotedString();
        if (\u26032.isEmpty()) {
            this.field_197663_n.setCursor(n);
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        return this.func_193596_c(\u26032);
    }

    private INBT func_193596_c(String string) {
        try {
            if (field_193617_c.matcher(string).matches()) {
                return new FloatNBT(Float.parseFloat(string.substring(0, string.length() - 1)));
            }
            if (field_193618_d.matcher(string).matches()) {
                return new ByteNBT(Byte.parseByte(string.substring(0, string.length() - 1)));
            }
            if (field_193619_e.matcher(string).matches()) {
                return new LongNBT(Long.parseLong(string.substring(0, string.length() - 1)));
            }
            if (field_193620_f.matcher(string).matches()) {
                return new ShortNBT(Short.parseShort(string.substring(0, string.length() - 1)));
            }
            if (field_193621_g.matcher(string).matches()) {
                return new IntNBT(Integer.parseInt(string));
            }
            if (field_193616_b.matcher(string).matches()) {
                return new DoubleNBT(Double.parseDouble(string.substring(0, string.length() - 1)));
            }
            if (field_193615_a.matcher(string).matches()) {
                return new DoubleNBT(Double.parseDouble(string));
            }
            if ("true".equalsIgnoreCase(string)) {
                return new ByteNBT(1);
            }
            if ("false".equalsIgnoreCase(string)) {
                return new ByteNBT(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new StringNBT(string);
    }

    public INBT func_193610_d() throws CommandSyntaxException {
        this.field_197663_n.skipWhitespace();
        if (!this.field_197663_n.canRead()) {
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        char c = this.field_197663_n.peek();
        if (c == '{') {
            return this.func_193593_f();
        }
        if (c == '[') {
            return this.func_193605_e();
        }
        return this.func_193611_c();
    }

    protected INBT func_193605_e() throws CommandSyntaxException {
        if (this.field_197663_n.canRead(3) && !StringReader.isQuotedStringStart((char)this.field_197663_n.peek(1)) && this.field_197663_n.peek(2) == ';') {
            return this.func_193606_k();
        }
        return this.func_193600_j();
    }

    public CompoundNBT func_193593_f() throws CommandSyntaxException {
        this.func_193604_b('{');
        CompoundNBT compoundNBT = new CompoundNBT();
        this.field_197663_n.skipWhitespace();
        while (this.field_197663_n.canRead() && this.field_197663_n.peek() != '}') {
            int n = this.field_197663_n.getCursor();
            String \u26032 = this.func_193601_b();
            if (\u26032.isEmpty()) {
                this.field_197663_n.setCursor(n);
                throw field_197658_b.createWithContext((ImmutableStringReader)this.field_197663_n);
            }
            this.func_193604_b(':');
            compoundNBT.func_218657_a(\u26032, this.func_193610_d());
            if (!this.func_193613_m()) break;
            if (this.field_197663_n.canRead()) continue;
            throw field_197658_b.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        this.func_193604_b('}');
        return compoundNBT;
    }

    private INBT func_193600_j() throws CommandSyntaxException {
        this.func_193604_b('[');
        this.field_197663_n.skipWhitespace();
        if (!this.field_197663_n.canRead()) {
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        ListNBT listNBT = new ListNBT();
        byte \u26032 = -1;
        while (this.field_197663_n.peek() != ']') {
            int n = this.field_197663_n.getCursor();
            INBT \u26033 = this.func_193610_d();
            byte \u26034 = \u26033.func_74732_a();
            if (\u26032 < 0) {
                \u26032 = \u26034;
            } else if (\u26034 != \u26032) {
                this.field_197663_n.setCursor(n);
                throw field_197660_d.createWithContext((ImmutableStringReader)this.field_197663_n, (Object)INBT.func_193581_j(\u26034), (Object)INBT.func_193581_j(\u26032));
            }
            listNBT.add(\u26033);
            if (!this.func_193613_m()) break;
            if (this.field_197663_n.canRead()) continue;
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        this.func_193604_b(']');
        return listNBT;
    }

    private INBT func_193606_k() throws CommandSyntaxException {
        this.func_193604_b('[');
        int n = this.field_197663_n.getCursor();
        char \u26032 = this.field_197663_n.read();
        this.field_197663_n.read();
        this.field_197663_n.skipWhitespace();
        if (!this.field_197663_n.canRead()) {
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        if (\u26032 == 'B') {
            return new ByteArrayNBT(this.func_193603_a((byte)7, (byte)1));
        }
        if (\u26032 == 'L') {
            return new LongArrayNBT(this.func_193603_a((byte)12, (byte)4));
        }
        if (\u26032 == 'I') {
            return new IntArrayNBT(this.func_193603_a((byte)11, (byte)3));
        }
        this.field_197663_n.setCursor(n);
        throw field_197662_f.createWithContext((ImmutableStringReader)this.field_197663_n, (Object)String.valueOf(\u26032));
    }

    private <T extends Number> List<T> func_193603_a(byte by, byte by2) throws CommandSyntaxException {
        ArrayList arrayList = Lists.newArrayList();
        while (this.field_197663_n.peek() != ']') {
            int n = this.field_197663_n.getCursor();
            INBT \u26032 = this.func_193610_d();
            byte \u26033 = \u26032.func_74732_a();
            if (\u26033 != by2) {
                this.field_197663_n.setCursor(n);
                throw field_197661_e.createWithContext((ImmutableStringReader)this.field_197663_n, (Object)INBT.func_193581_j(\u26033), (Object)INBT.func_193581_j(by));
            }
            if (by2 == 1) {
                arrayList.add(((NumberNBT)\u26032).func_150290_f());
            } else if (by2 == 4) {
                arrayList.add(((NumberNBT)\u26032).func_150291_c());
            } else {
                arrayList.add(((NumberNBT)\u26032).func_150287_d());
            }
            if (!this.func_193613_m()) break;
            if (this.field_197663_n.canRead()) continue;
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        this.func_193604_b(']');
        return arrayList;
    }

    private boolean func_193613_m() {
        this.field_197663_n.skipWhitespace();
        if (this.field_197663_n.canRead() && this.field_197663_n.peek() == ',') {
            this.field_197663_n.skip();
            this.field_197663_n.skipWhitespace();
            return true;
        }
        return false;
    }

    private void func_193604_b(char c) throws CommandSyntaxException {
        this.field_197663_n.skipWhitespace();
        this.field_197663_n.expect(c);
    }
}

