/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ShulkerBulletEntity
extends Entity {
    private LivingEntity field_184570_a;
    private Entity field_184571_b;
    @Nullable
    private Direction field_184573_c;
    private int field_184575_d;
    private double field_184577_e;
    private double field_184578_f;
    private double field_184579_g;
    @Nullable
    private UUID field_184580_h;
    private BlockPos field_184572_as;
    @Nullable
    private UUID field_184574_at;
    private BlockPos field_184576_au;

    public ShulkerBulletEntity(EntityType<? extends ShulkerBulletEntity> entityType, World world) {
        super(entityType, world);
        this.field_70145_X = true;
    }

    public ShulkerBulletEntity(World world, LivingEntity livingEntity, Entity entity, Direction.Axis axis) {
        this((EntityType<? extends ShulkerBulletEntity>)EntityType.field_200739_ae, world);
        this.field_184570_a = livingEntity;
        BlockPos blockPos = new BlockPos(livingEntity);
        double \u26032 = (double)blockPos.func_177958_n() + 0.5;
        double \u26033 = (double)blockPos.func_177956_o() + 0.5;
        double \u26034 = (double)blockPos.func_177952_p() + 0.5;
        this.func_70012_b(\u26032, \u26033, \u26034, this.field_70177_z, this.field_70125_A);
        this.field_184571_b = entity;
        this.field_184573_c = Direction.UP;
        this.func_184569_a(axis);
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected void func_213281_b(CompoundNBT compoundNBT) {
        CompoundNBT \u26032;
        if (this.field_184570_a != null) {
            BlockPos blockPos = new BlockPos(this.field_184570_a);
            \u26032 = NBTUtil.func_186862_a(this.field_184570_a.func_110124_au());
            \u26032.func_74768_a("X", blockPos.func_177958_n());
            \u26032.func_74768_a("Y", blockPos.func_177956_o());
            \u26032.func_74768_a("Z", blockPos.func_177952_p());
            compoundNBT.func_218657_a("Owner", \u26032);
        }
        if (this.field_184571_b != null) {
            blockPos = new BlockPos(this.field_184571_b);
            \u26032 = NBTUtil.func_186862_a(this.field_184571_b.func_110124_au());
            \u26032.func_74768_a("X", blockPos.func_177958_n());
            \u26032.func_74768_a("Y", blockPos.func_177956_o());
            \u26032.func_74768_a("Z", blockPos.func_177952_p());
            compoundNBT.func_218657_a("Target", \u26032);
        }
        if (this.field_184573_c != null) {
            compoundNBT.func_74768_a("Dir", this.field_184573_c.func_176745_a());
        }
        compoundNBT.func_74768_a("Steps", this.field_184575_d);
        compoundNBT.func_74780_a("TXD", this.field_184577_e);
        compoundNBT.func_74780_a("TYD", this.field_184578_f);
        compoundNBT.func_74780_a("TZD", this.field_184579_g);
    }

    @Override
    protected void func_70037_a(CompoundNBT compoundNBT) {
        this.field_184575_d = compoundNBT.func_74762_e("Steps");
        this.field_184577_e = compoundNBT.func_74769_h("TXD");
        this.field_184578_f = compoundNBT.func_74769_h("TYD");
        this.field_184579_g = compoundNBT.func_74769_h("TZD");
        if (compoundNBT.func_150297_b("Dir", 99)) {
            this.field_184573_c = Direction.func_82600_a(compoundNBT.func_74762_e("Dir"));
        }
        if (compoundNBT.func_150297_b("Owner", 10)) {
            \u2603 = compoundNBT.func_74775_l("Owner");
            this.field_184580_h = NBTUtil.func_186860_b(\u2603);
            this.field_184572_as = new BlockPos(\u2603.func_74762_e("X"), \u2603.func_74762_e("Y"), \u2603.func_74762_e("Z"));
        }
        if (compoundNBT.func_150297_b("Target", 10)) {
            \u2603 = compoundNBT.func_74775_l("Target");
            this.field_184574_at = NBTUtil.func_186860_b(\u2603);
            this.field_184576_au = new BlockPos(\u2603.func_74762_e("X"), \u2603.func_74762_e("Y"), \u2603.func_74762_e("Z"));
        }
    }

    @Override
    protected void func_70088_a() {
    }

    private void func_184568_a(@Nullable Direction direction) {
        this.field_184573_c = direction;
    }

    private void func_184569_a(@Nullable Direction.Axis axis) {
        double d;
        BlockPos \u26032;
        double d2 = 0.5;
        if (this.field_184571_b == null) {
            \u26032 = new BlockPos(this).func_177977_b();
        } else {
            d2 = (double)this.field_184571_b.func_213302_cg() * 0.5;
            \u26032 = new BlockPos(this.field_184571_b.field_70165_t, this.field_184571_b.field_70163_u + d2, this.field_184571_b.field_70161_v);
        }
        d = (double)\u26032.func_177958_n() + 0.5;
        \u2603 = (double)\u26032.func_177956_o() + d2;
        \u2603 = (double)\u26032.func_177952_p() + 0.5;
        Direction \u26034 = null;
        if (!\u26032.func_218137_a(this.func_213303_ch(), 2.0)) {
            BlockPos blockPos = new BlockPos(this);
            ArrayList \u26033 = Lists.newArrayList();
            if (axis != Direction.Axis.X) {
                if (blockPos.func_177958_n() < \u26032.func_177958_n() && this.field_70170_p.func_175623_d(blockPos.func_177974_f())) {
                    \u26033.add(Direction.EAST);
                } else if (blockPos.func_177958_n() > \u26032.func_177958_n() && this.field_70170_p.func_175623_d(blockPos.func_177976_e())) {
                    \u26033.add(Direction.WEST);
                }
            }
            if (axis != Direction.Axis.Y) {
                if (blockPos.func_177956_o() < \u26032.func_177956_o() && this.field_70170_p.func_175623_d(blockPos.func_177984_a())) {
                    \u26033.add(Direction.UP);
                } else if (blockPos.func_177956_o() > \u26032.func_177956_o() && this.field_70170_p.func_175623_d(blockPos.func_177977_b())) {
                    \u26033.add(Direction.DOWN);
                }
            }
            if (axis != Direction.Axis.Z) {
                if (blockPos.func_177952_p() < \u26032.func_177952_p() && this.field_70170_p.func_175623_d(blockPos.func_177968_d())) {
                    \u26033.add(Direction.SOUTH);
                } else if (blockPos.func_177952_p() > \u26032.func_177952_p() && this.field_70170_p.func_175623_d(blockPos.func_177978_c())) {
                    \u26033.add(Direction.NORTH);
                }
            }
            \u26034 = Direction.func_176741_a(this.field_70146_Z);
            if (\u26033.isEmpty()) {
                for (int i = 5; !this.field_70170_p.func_175623_d(blockPos.func_177972_a(\u26034)) && i > 0; --i) {
                    \u26034 = Direction.func_176741_a(this.field_70146_Z);
                }
            } else {
                \u26034 = (Direction)\u26033.get(this.field_70146_Z.nextInt(\u26033.size()));
            }
            d = this.field_70165_t + (double)\u26034.func_82601_c();
            \u2603 = this.field_70163_u + (double)\u26034.func_96559_d();
            \u2603 = this.field_70161_v + (double)\u26034.func_82599_e();
        }
        this.func_184568_a(\u26034);
        \u2603 = d - this.field_70165_t;
        \u2603 = \u2603 - this.field_70163_u;
        \u2603 = \u2603 - this.field_70161_v;
        \u2603 = MathHelper.func_76133_a(\u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603);
        if (\u2603 == 0.0) {
            this.field_184577_e = 0.0;
            this.field_184578_f = 0.0;
            this.field_184579_g = 0.0;
        } else {
            this.field_184577_e = \u2603 / \u2603 * 0.15;
            this.field_184578_f = \u2603 / \u2603 * 0.15;
            this.field_184579_g = \u2603 / \u2603 * 0.15;
        }
        this.field_70160_al = true;
        this.field_184575_d = 10 + this.field_70146_Z.nextInt(5) * 10;
    }

    @Override
    public void func_70071_h_() {
        Object object;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
            return;
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            Iterator<LivingEntity> iterator;
            if (this.field_184571_b == null && this.field_184574_at != null) {
                object = this.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.field_184576_au.func_177982_a(-2, -2, -2), this.field_184576_au.func_177982_a(2, 2, 2)));
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    \u26032 = iterator.next();
                    if (!((Entity)\u26032).func_110124_au().equals(this.field_184574_at)) continue;
                    this.field_184571_b = \u26032;
                    break;
                }
                this.field_184574_at = null;
            }
            if (this.field_184570_a == null && this.field_184580_h != null) {
                object = this.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.field_184572_as.func_177982_a(-2, -2, -2), this.field_184572_as.func_177982_a(2, 2, 2)));
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    \u26032 = iterator.next();
                    if (!((Entity)\u26032).func_110124_au().equals(this.field_184580_h)) continue;
                    this.field_184570_a = \u26032;
                    break;
                }
                this.field_184580_h = null;
            }
            if (!(this.field_184571_b == null || !this.field_184571_b.func_70089_S() || this.field_184571_b instanceof PlayerEntity && ((PlayerEntity)this.field_184571_b).func_175149_v())) {
                this.field_184577_e = MathHelper.func_151237_a(this.field_184577_e * 1.025, -1.0, 1.0);
                this.field_184578_f = MathHelper.func_151237_a(this.field_184578_f * 1.025, -1.0, 1.0);
                this.field_184579_g = MathHelper.func_151237_a(this.field_184579_g * 1.025, -1.0, 1.0);
                object = this.func_213322_ci();
                this.func_213317_d(((Vec3d)object).func_72441_c((this.field_184577_e - ((Vec3d)object).field_72450_a) * 0.2, (this.field_184578_f - ((Vec3d)object).field_72448_b) * 0.2, (this.field_184579_g - ((Vec3d)object).field_72449_c) * 0.2));
            } else if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            object = ProjectileHelper.func_221266_a(this, true, false, this.field_184570_a, RayTraceContext.BlockMode.COLLIDER);
            if (((RayTraceResult)object).func_216346_c() != RayTraceResult.Type.MISS) {
                this.func_184567_a((RayTraceResult)object);
            }
        }
        object = this.func_213322_ci();
        this.func_70107_b(this.field_70165_t + ((Vec3d)object).field_72450_a, this.field_70163_u + ((Vec3d)object).field_72448_b, this.field_70161_v + ((Vec3d)object).field_72449_c);
        ProjectileHelper.func_188803_a(this, 0.5f);
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a(ParticleTypes.field_197624_q, this.field_70165_t - ((Vec3d)object).field_72450_a, this.field_70163_u - ((Vec3d)object).field_72448_b + 0.15, this.field_70161_v - ((Vec3d)object).field_72449_c, 0.0, 0.0, 0.0);
        } else if (this.field_184571_b != null && !this.field_184571_b.field_70128_L) {
            if (this.field_184575_d > 0) {
                --this.field_184575_d;
                if (this.field_184575_d == 0) {
                    this.func_184569_a(this.field_184573_c == null ? null : this.field_184573_c.func_176740_k());
                }
            }
            if (this.field_184573_c != null) {
                BlockPos blockPos = new BlockPos(this);
                Object \u26032 = this.field_184573_c.func_176740_k();
                if (this.field_70170_p.func_217400_a(blockPos.func_177972_a(this.field_184573_c), this)) {
                    this.func_184569_a((Direction.Axis)\u26032);
                } else {
                    \u2603 = new BlockPos(this.field_184571_b);
                    if (\u26032 == Direction.Axis.X && blockPos.func_177958_n() == \u2603.func_177958_n() || \u26032 == Direction.Axis.Z && blockPos.func_177952_p() == \u2603.func_177952_p() || \u26032 == Direction.Axis.Y && blockPos.func_177956_o() == \u2603.func_177956_o()) {
                        this.func_184569_a((Direction.Axis)\u26032);
                    }
                }
            }
        }
    }

    @Override
    public boolean func_70027_ad() {
        return false;
    }

    @Override
    public float func_70013_c() {
        return 1.0f;
    }

    protected void func_184567_a(RayTraceResult rayTraceResult) {
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)rayTraceResult).func_216348_a();
            boolean \u26032 = entity.func_70097_a(DamageSource.func_188403_a(this, this.field_184570_a).func_76349_b(), 4.0f);
            if (\u26032) {
                this.func_174815_a(this.field_184570_a, entity);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_188424_y, 200));
                }
            }
        } else {
            ((ServerWorld)this.field_70170_p).func_195598_a(ParticleTypes.field_197627_t, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2, 0.2, 0.2, 0.2, 0.0);
            this.func_184185_a(SoundEvents.field_187775_eP, 1.0f, 1.0f);
        }
        this.func_70106_y();
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundEvents.field_187777_eQ, 1.0f, 1.0f);
            ((ServerWorld)this.field_70170_p).func_195598_a(ParticleTypes.field_197614_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15, 0.2, 0.2, 0.2, 0.0);
            this.func_70106_y();
        }
        return true;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket(this);
    }
}

