/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class MoveToSkylightTask
extends Task<LivingEntity> {
    private final float field_220494_a;

    public MoveToSkylightTask(float f) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(MemoryModuleType.field_220950_k, (Object)((Object)MemoryModuleStatus.VALUE_ABSENT)));
        this.field_220494_a = f;
    }

    @Override
    protected void func_212831_a_(ServerWorld serverWorld, LivingEntity livingEntity, long l) {
        Optional<Vec3d> optional = Optional.ofNullable(this.func_220493_b(serverWorld, livingEntity));
        if (optional.isPresent()) {
            livingEntity.func_213375_cj().func_218226_a(MemoryModuleType.field_220950_k, optional.map(vec3d -> new WalkTarget((Vec3d)vec3d, this.field_220494_a, 0)));
        }
    }

    @Override
    protected boolean func_212832_a_(ServerWorld serverWorld, LivingEntity livingEntity) {
        return !serverWorld.func_217337_f(new BlockPos(livingEntity.field_70165_t, livingEntity.func_174813_aQ().field_72338_b, livingEntity.field_70161_v));
    }

    @Nullable
    private Vec3d func_220493_b(ServerWorld serverWorld, LivingEntity livingEntity) {
        Random random = livingEntity.func_70681_au();
        BlockPos \u26032 = new BlockPos(livingEntity.field_70165_t, livingEntity.func_174813_aQ().field_72338_b, livingEntity.field_70161_v);
        for (int i = 0; i < 10; ++i) {
            BlockPos blockPos = \u26032.func_177982_a(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (!MoveToSkylightTask.func_223015_b(serverWorld, livingEntity)) continue;
            return new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean func_223015_b(ServerWorld serverWorld, LivingEntity livingEntity) {
        if (!serverWorld.func_217337_f(new BlockPos(livingEntity))) return false;
        BlockPos blockPos = new BlockPos(livingEntity);
        if (!((double)serverWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockPos).func_177956_o() <= livingEntity.field_70163_u)) return false;
        return true;
    }
}

