/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.gui;

import com.lothrazar.storagenetwork.api.util.UtilInventory;
import com.lothrazar.storagenetwork.gui.IGuiPrivate;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class ItemSlotNetwork {
    private final int x;
    private final int y;
    private int size;
    private final int guiLeft;
    private final int guiTop;
    private boolean showNumbers;
    private final IGuiPrivate parent;
    private ItemStack stack;

    public ItemSlotNetwork(IGuiPrivate parent, @Nonnull ItemStack stack, int x, int y, int size, int guiLeft, int guiTop, boolean number) {
        this.x = x;
        this.y = y;
        this.size = size;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.setShowNumbers(number);
        this.parent = parent;
        this.setStack(stack);
    }

    public boolean isMouseOverSlot(int mouseX, int mouseY) {
        return this.parent.isInRegion(this.x - this.guiLeft, this.y - this.guiTop, 16, 16, mouseX, mouseY);
    }

    public void drawSlot(FontRenderer font, int mx, int my) {
        GlStateManager.pushMatrix();
        if (!this.getStack().func_190926_b()) {
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(this.getStack(), this.x, this.y);
            String amount = Screen.hasShiftDown() ? this.size + "" : UtilInventory.formatLargeNumber(this.size);
            if (this.isShowNumbers()) {
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                Minecraft.func_71410_x().func_175599_af().func_180453_a(font, this.stack, this.x * 2 + 16, this.y * 2 + 16, amount);
                GlStateManager.popMatrix();
            }
        }
        if (this.isMouseOverSlot(mx, my)) {
            GlStateManager.disableLighting();
            GlStateManager.disableDepthTest();
            int j1 = this.x;
            int k1 = this.y;
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.parent.drawGradientRect(j1, k1, j1 + 16, k1 + 16, -2130706433, -2130706433);
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.enableLighting();
        }
        GlStateManager.popMatrix();
    }

    void drawTooltip(int mx, int my) {
        if (this.isMouseOverSlot(mx, my) && !this.getStack().func_190926_b()) {
            this.parent.renderStackToolTip(this.getStack(), mx - this.parent.getGuiLeft(), my - this.parent.getGuiTop());
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    private boolean isShowNumbers() {
        return this.showNumbers;
    }

    private void setShowNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }
}

