/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockTools {
    private static final Random random = new Random();

    public static void emptyInventoryInWorld(World world, int x, int y, int z, Block block, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            BlockTools.spawnItemStack(world, x, y, z, itemstack);
            inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public static void spawnItemStack(World world, int x, int y, int z, ItemStack itemstack) {
        if (!itemstack.func_190926_b()) {
            ItemEntity entityItem = new ItemEntity(world, (double)x, (double)y, (double)z, itemstack);
            world.func_217376_c((Entity)entityItem);
        }
    }

    public static Block getBlock(ItemStack stack) {
        if (stack.func_77973_b() instanceof BlockItem) {
            return ((BlockItem)stack.func_77973_b()).func_179223_d();
        }
        return null;
    }

    public static String getModid(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return stack.func_77973_b().getRegistryName().func_110624_b();
        }
        return "";
    }

    public static String getModidForBlock(Block block) {
        ResourceLocation nameForObject = block.getRegistryName();
        if (nameForObject == null) {
            return "?";
        }
        return nameForObject.func_110624_b();
    }

    public static String getReadableName(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return BlockTools.getReadableName(state.func_177230_c().func_185473_a((IBlockReader)world, pos, state));
    }

    public static String getReadableName(ItemStack stack) {
        return stack.func_200301_q().func_150254_d();
    }

    public static BlockState placeStackAt(PlayerEntity player, ItemStack blockStack, World world, BlockPos pos, @Nullable BlockState origState) {
        BlockRayTraceResult trace = new BlockRayTraceResult(new Vec3d(0.0, 0.0, 0.0), Direction.UP, pos, false);
        BlockItemUseContext context = new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, trace));
        if (blockStack.func_77973_b() instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)blockStack.func_77973_b();
            if (origState == null) {
                origState = itemBlock.func_179223_d().func_196258_a(context);
            }
            if (itemBlock.func_195942_a(context) == ActionResultType.SUCCESS) {
                blockStack.func_190918_g(1);
            }
            return origState;
        }
        player.func_184611_a(Hand.MAIN_HAND, blockStack);
        player.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
        blockStack.func_77973_b().func_195939_a((ItemUseContext)context);
        return world.func_180495_p(pos);
    }
}

