/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorChoiceLabel;
import mcjty.lib.gui.widgets.ColorSelector;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.IconHolder;
import mcjty.lib.gui.widgets.IconRender;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TabbedPanel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class WidgetRepository {
    private static final Map<String, BiFunction<Minecraft, Screen, Widget<?>>> FACTORIES = new HashMap();

    @Nullable
    public static Widget<?> createWidget(String type, Minecraft minecraft, Screen gui) {
        BiFunction<Minecraft, Screen, Widget<?>> function = FACTORIES.get(type);
        if (function == null) {
            return null;
        }
        return function.apply(minecraft, gui);
    }

    static {
        FACTORIES.put("blockrender", BlockRender::new);
        FACTORIES.put("button", Button::new);
        FACTORIES.put("label", Label::new);
        FACTORIES.put("choicelabel", ChoiceLabel::new);
        FACTORIES.put("colorchoicelabel", ColorChoiceLabel::new);
        FACTORIES.put("colorselector", ColorSelector::new);
        FACTORIES.put("energybar", EnergyBar::new);
        FACTORIES.put("iconholder", IconHolder::new);
        FACTORIES.put("iconrender", IconRender::new);
        FACTORIES.put("imagechoicelabel", ImageChoiceLabel::new);
        FACTORIES.put("imagelabel", ImageLabel::new);
        FACTORIES.put("panel", Panel::new);
        FACTORIES.put("scrollablelabel", ScrollableLabel::new);
        FACTORIES.put("slider", Slider::new);
        FACTORIES.put("tabbedpanel", TabbedPanel::new);
        FACTORIES.put("textfield", TextField::new);
        FACTORIES.put("togglebutton", ToggleButton::new);
        FACTORIES.put("widgetlist", WidgetList::new);
    }
}

