/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GuiSideWindow;
import mcjty.lib.gui.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class GuiItemScreen
extends Screen {
    protected ModBase modBase;
    protected SimpleChannel network;
    protected Window window;
    protected int xSize;
    protected int ySize;
    protected int guiLeft;
    protected int guiTop;
    private GuiSideWindow sideWindow;

    public GuiItemScreen(ModBase mod, SimpleChannel network, int xSize, int ySize, int manual, String manualNode) {
        super((ITextComponent)new StringTextComponent("todo"));
        this.modBase = mod;
        this.network = network;
        this.xSize = xSize;
        this.ySize = ySize;
        this.sideWindow = new GuiSideWindow(manual, manualNode);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.sideWindow.initGui(this.modBase, this.network, this.getMinecraft(), this, this.guiLeft, this.guiTop, this.xSize, this.ySize);
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean rc = super.mouseClicked(x, y, button);
        this.window.mouseClicked((int)x, (int)y, button);
        this.sideWindow.getWindow().mouseClicked((int)x, (int)y, button);
        return rc;
    }

    public boolean mouseDragged(double x, double y, int button, double scaledX, double scaledY) {
        boolean rc = super.mouseDragged(x, y, button, scaledX, scaledX);
        this.window.handleMouseInput(button);
        this.sideWindow.getWindow().handleMouseInput(button);
        return rc;
    }

    public boolean mouseReleased(double x, double y, int state) {
        boolean rc = super.mouseReleased(x, y, state);
        this.window.mouseMovedOrUp((int)x, (int)y, state);
        this.sideWindow.getWindow().mouseMovedOrUp((int)x, (int)y, state);
        return rc;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean rc = super.keyPressed(keyCode, scanCode, modifiers);
        this.window.keyTyped(keyCode, scanCode);
        return rc;
    }

    public void drawWindow() {
        int y;
        int x;
        this.renderBackground();
        this.window.draw();
        this.sideWindow.getWindow().draw();
        List<String> tooltips = this.window.getTooltips();
        Minecraft mc = this.getMinecraft();
        if (tooltips != null) {
            x = (int)mc.field_71417_B.func_198024_e() * this.width / mc.field_195558_d.func_198105_m();
            y = this.height - (int)mc.field_71417_B.func_198026_f() * this.height / mc.field_195558_d.func_198083_n() - 1;
            this.renderTooltip(tooltips, x - this.guiLeft, y - this.guiTop, mc.field_71466_p);
        }
        if ((tooltips = this.sideWindow.getWindow().getTooltips()) != null) {
            x = (int)mc.field_71417_B.func_198024_e() * this.width / mc.field_195558_d.func_198105_m();
            y = this.height - (int)mc.field_71417_B.func_198026_f() * this.height / mc.field_195558_d.func_198083_n() - 1;
            this.renderTooltip(tooltips, x - this.guiLeft, y - this.guiTop, mc.field_71466_p);
        }
    }
}

