/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.Direction;

public class HudRenderHelper {
    public static void renderHud(List<String> messages, HudPlacement hudPlacement, HudOrientation hudOrientation, Direction orientation, double x, double y, double z, float scale) {
        GlStateManager.pushMatrix();
        if (hudPlacement == HudPlacement.HUD_FRONT) {
            GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        } else if (hudPlacement == HudPlacement.HUD_CENTER) {
            GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        } else {
            GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 1.75f), (float)((float)z + 0.5f));
        }
        switch (hudOrientation) {
            case HUD_SOUTH: {
                GlStateManager.rotatef((float)(-HudRenderHelper.getHudAngle(orientation)), (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case HUD_TOPLAYER_HORIZ: {
                GlStateManager.rotatef((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case HUD_TOPLAYER: {
                GlStateManager.rotatef((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        if (hudPlacement == HudPlacement.HUD_FRONT || hudPlacement == HudPlacement.HUD_ABOVE_FRONT) {
            GlStateManager.translatef((float)0.0f, (float)-0.25f, (float)0.46249998f);
        } else if (hudPlacement != HudPlacement.HUD_CENTER) {
            GlStateManager.translatef((float)0.0f, (float)-0.25f, (float)-0.037499994f);
        }
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.disableBlend();
        GlStateManager.disableLighting();
        HudRenderHelper.renderText(Minecraft.func_71410_x().field_71466_p, messages, 11, scale);
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        GlStateManager.enableLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.popMatrix();
    }

    private static float getHudAngle(Direction orientation) {
        float f3 = 0.0f;
        if (orientation != null) {
            switch (orientation) {
                case NORTH: {
                    f3 = 180.0f;
                    break;
                }
                case WEST: {
                    f3 = 90.0f;
                    break;
                }
                case EAST: {
                    f3 = -90.0f;
                    break;
                }
                default: {
                    f3 = 0.0f;
                }
            }
        }
        return f3;
    }

    private static void renderText(FontRenderer fontrenderer, List<String> messages, int lines, float scale) {
        GlStateManager.translatef((float)-0.5f, (float)0.5f, (float)0.07f);
        float f3 = 0.0075f;
        GlStateManager.scalef((float)(f3 * scale), (float)(-f3 * scale), (float)f3);
        GlStateManager.normal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        HudRenderHelper.renderLog(fontrenderer, messages, lines);
    }

    private static void renderLog(FontRenderer fontrenderer, List<String> messages, int lines) {
        int currenty = 7;
        int height = 10;
        int logsize = messages.size();
        int i = 0;
        for (String s : messages) {
            if (i >= logsize - lines && currenty + height <= 124) {
                fontrenderer.func_211126_b(fontrenderer.func_78269_a(s, 115), 7.0f, (float)currenty, 0xFFFFFF);
                currenty += height;
            }
            ++i;
        }
    }

    public static enum HudOrientation {
        HUD_SOUTH,
        HUD_TOPLAYER_HORIZ,
        HUD_TOPLAYER;

    }

    public static enum HudPlacement {
        HUD_ABOVE,
        HUD_ABOVE_FRONT,
        HUD_FRONT,
        HUD_CENTER;

    }
}

