/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.blocks;

import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InformationString;
import mcjty.lib.compat.CofhApiItemCompatibility;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.compat.waila.WailaInfoProvider;
import mcjty.lib.multipart.IPartBlock;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.WrenchChecker;
import mcjty.lib.varia.WrenchUsage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.StringUtils;

public class BaseBlock
extends Block
implements WailaInfoProvider,
TOPInfoProvider,
IPartBlock {
    private final boolean infusable;
    private final boolean hasGui;
    private final Supplier<TileEntity> tileEntitySupplier;
    private final InformationString informationString;
    private final InformationString informationStringWithShift;
    private final ToolType toolType;
    private final int harvestLevel;
    private final TOPDriver topDriver;
    public static final IProperty<?>[] HORIZ_PROPERTIES = new IProperty[]{BlockStateProperties.field_208157_J};
    public static final IProperty<?>[] ROTATING_PROPERTIES = new IProperty[]{BlockStateProperties.field_208155_H};
    public static final IProperty<?>[] NONE_PROPERTIES = new IProperty[0];
    private static final Pattern COMPILE = Pattern.compile("@", 16);

    public BaseBlock(String name, BlockBuilder builder) {
        super(builder.getProperties());
        this.setRegistryName(name);
        this.infusable = builder.isInfusable();
        this.hasGui = builder.isHasGui();
        this.tileEntitySupplier = builder.getTileEntitySupplier();
        this.informationString = builder.getInformationString();
        this.informationStringWithShift = builder.getInformationStringWithShift();
        this.toolType = builder.getToolType();
        this.harvestLevel = builder.getHarvestLevel();
        this.topDriver = builder.getTopDriver();
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        this.intAddInformation(stack, tooltip);
        InformationString i = this.informationString;
        if (McJtyLib.proxy.isShiftKeyDown()) {
            i = this.informationStringWithShift;
        }
        if (i != null) {
            BaseBlock.addLocalizedInformation(i, stack, tooltip);
        }
    }

    private void intAddInformation(ItemStack itemStack, List<ITextComponent> list) {
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            if (tagCompound.func_74764_b("Energy")) {
                long energy = tagCompound.func_74763_f("Energy");
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Energy: " + energy + " rf"));
            }
            if (this.isInfusable()) {
                int infused = tagCompound.func_74762_e("infused");
                int pct = infused * 100 / (Integer)GeneralConfig.maxInfuse.get();
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Infused: " + pct + "%"));
            }
            if (((Boolean)GeneralConfig.manageOwnership.get()).booleanValue() && tagCompound.func_74764_b("owner")) {
                String owner = tagCompound.func_74779_i("owner");
                int securityChannel = -1;
                if (tagCompound.func_74764_b("secChannel")) {
                    securityChannel = tagCompound.func_74762_e("secChannel");
                }
                if (securityChannel == -1) {
                    list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Owned by: " + owner));
                } else {
                    list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Owned by: " + owner + " (channel " + securityChannel + ")"));
                }
                if (!tagCompound.func_74764_b("idM")) {
                    list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Warning! Ownership not correctly set! Please place block again!"));
                }
            }
        }
    }

    private WrenchUsage testWrenchUsage(BlockPos pos, PlayerEntity player) {
        Item item;
        ItemStack itemStack = player.func_184586_b(Hand.MAIN_HAND);
        WrenchUsage wrenchUsed = WrenchUsage.NOT;
        if (!itemStack.func_190926_b() && (item = itemStack.func_77973_b()) != null) {
            wrenchUsed = this.getWrenchUsage(pos, player, itemStack, wrenchUsed, item);
        }
        if (wrenchUsed == WrenchUsage.NORMAL && player.func_70093_af()) {
            wrenchUsed = WrenchUsage.SNEAKING;
        }
        return wrenchUsed;
    }

    protected WrenchUsage getWrenchUsage(BlockPos pos, PlayerEntity player, ItemStack itemStack, WrenchUsage wrenchUsed, Item item) {
        if (item instanceof SmartWrench) {
            switch (((SmartWrench)item).getMode(itemStack)) {
                case MODE_WRENCH: {
                    return WrenchUsage.NORMAL;
                }
                case MODE_SELECT: {
                    return player.func_70093_af() ? WrenchUsage.SNEAK_SELECT : WrenchUsage.SELECT;
                }
            }
            throw new RuntimeException("SmartWrench in unknown mode!");
        }
        if (McJtyLib.cofhapiitem && CofhApiItemCompatibility.isToolHammer(item)) {
            return CofhApiItemCompatibility.getWrenchUsage(item, itemStack, player, pos);
        }
        if (WrenchChecker.isAWrench(item)) {
            return WrenchUsage.NORMAL;
        }
        return wrenchUsed;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity && ((GenericTileEntity)te).onBlockActivated(state, player, hand, result)) {
            return true;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        WrenchUsage wrenchUsed = this.testWrenchUsage(pos, player);
        switch (wrenchUsed) {
            case NOT: {
                return this.openGui(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player);
            }
            case NORMAL: {
                return this.wrenchUse(world, pos, result.func_216354_b(), player);
            }
            case SNEAKING: {
                return this.wrenchSneak(world, pos, player);
            }
            case DISABLED: {
                return this.wrenchDisabled(world, pos, player);
            }
            case SELECT: {
                return this.wrenchSelect(world, pos, player);
            }
            case SNEAK_SELECT: {
                return this.wrenchSneakSelect(world, pos, player);
            }
        }
        return false;
    }

    protected boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof GenericTileEntity) {
            if (!((GenericTileEntity)tileEntity).wrenchUse(world, pos, side, player)) {
                this.rotate(world.func_180495_p(pos), (IWorld)world, pos, Rotation.CLOCKWISE_90);
            }
        } else {
            this.rotate(world.func_180495_p(pos), (IWorld)world, pos, Rotation.CLOCKWISE_90);
        }
        return true;
    }

    protected boolean wrenchSneak(World world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    protected boolean wrenchDisabled(World world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    protected boolean wrenchSelect(World world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    protected boolean wrenchSneakSelect(World world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    protected boolean openGui(World world, int x, int y, int z, PlayerEntity player) {
        if (this.hasGui) {
            if (world.field_72995_K) {
                return true;
            }
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (!(te instanceof INamedContainerProvider)) {
                return true;
            }
            if (this.checkAccess(world, player, te)) {
                return true;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)te.func_174877_v());
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && ((Boolean)GeneralConfig.manageOwnership.get()).booleanValue()) {
            this.setOwner(world, pos, placer);
        }
        if ((te = world.func_175625_s(pos)) instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.onBlockPlacedBy(world, pos, state, placer, stack);
        }
        this.checkRedstone(world, pos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, p_220069_6_);
        this.checkRedstone(world, pos);
    }

    protected void checkRedstone(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity) {
            ((GenericTileEntity)te).checkRedstone(world, pos);
        }
    }

    protected void setOwner(World world, BlockPos pos, LivingEntity entity) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity && entity instanceof PlayerEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            PlayerEntity player = (PlayerEntity)entity;
            genericTileEntity.setOwner(player);
        }
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        if (this.hasTileEntity(state)) {
            super.func_189539_a(state, worldIn, pos, id, param);
            TileEntity tileentity = worldIn.func_175625_s(pos);
            return tileentity == null ? false : tileentity.func_145842_c(id, param);
        }
        return super.func_189539_a(state, worldIn, pos, id, param);
    }

    protected boolean checkAccess(World world, PlayerEntity player, TileEntity te) {
        if (te instanceof GenericTileEntity) {
            ((GenericTileEntity)te).checkAccess(player);
        }
        return false;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return this.toolType;
    }

    public int getHarvestLevel(BlockState state) {
        return this.harvestLevel;
    }

    public boolean hasTileEntity(BlockState state) {
        return this.tileEntitySupplier != null;
    }

    public RotationType getRotationType() {
        return RotationType.ROTATION;
    }

    public boolean isInfusable() {
        return this.infusable;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (this.tileEntitySupplier == null) {
            return null;
        }
        return this.tileEntitySupplier.get();
    }

    @Override
    @Nonnull
    public PartSlot getSlotFromState(World world, BlockPos pos, BlockState newState) {
        return PartSlot.NONE;
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.onReplaced(world, pos, state);
        }
        super.func_196243_a(state, world, pos, newstate, isMoving);
    }

    protected IProperty<?>[] getProperties() {
        return BaseBlock.getProperties(this.getRotationType());
    }

    public static IProperty<?>[] getProperties(RotationType rotationType) {
        switch (rotationType) {
            case HORIZROTATION: {
                return HORIZ_PROPERTIES;
            }
            case ROTATION: {
                return ROTATING_PROPERTIES;
            }
        }
        return NONE_PROPERTIES;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        for (IProperty<?> property : this.getProperties()) {
            builder.func_206894_a(new IProperty[]{property});
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        PlayerEntity placer = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        BlockState state = super.func_196258_a(context);
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)placer.func_174811_aO().func_176734_d());
            }
            case ROTATION: {
                return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)OrientationTools.getFacingFromEntity(pos, (Entity)placer));
            }
        }
        return state;
    }

    protected Direction getOrientation(BlockPos pos, LivingEntity entity) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return OrientationTools.determineOrientationHoriz(entity);
            }
            case ROTATION: {
                return OrientationTools.determineOrientation(pos, entity);
            }
        }
        return null;
    }

    public Direction getFrontDirection(BlockState state) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
            }
            case ROTATION: {
                return (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
            }
        }
        return Direction.NORTH;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rot) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)));
            }
            case ROTATION: {
                state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)));
            }
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof GenericTileEntity) {
            ((GenericTileEntity)tileEntity).rotateBlock(rot);
        }
        return state;
    }

    public Direction getRightDirection(BlockState state) {
        return this.getFrontDirection(state).func_176735_f();
    }

    public Direction getLeftDirection(BlockState state) {
        return this.getFrontDirection(state).func_176746_e();
    }

    public static Direction getFrontDirection(RotationType rotationType, BlockState state) {
        switch (rotationType) {
            case HORIZROTATION: {
                return OrientationTools.getOrientationHoriz(state);
            }
            case ROTATION: {
                return OrientationTools.getOrientation(state);
            }
        }
        return Direction.SOUTH;
    }

    public static void addLocalizedInformation(InformationString informationString, ItemStack stack, List<ITextComponent> tooltip) {
        if (informationString != null) {
            String[] split;
            Object[] parameters = new Object[informationString.getInformationStringParameters().size()];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = informationString.getInformationStringParameters().get(i).apply(stack);
            }
            String translated = I18n.func_135052_a((String)informationString.getString(), (Object[])parameters);
            translated = COMPILE.matcher(translated).replaceAll("\u00a7");
            for (String s : split = StringUtils.split((String)translated, (String)"\n")) {
                tooltip.add((ITextComponent)new StringTextComponent(s));
            }
        }
    }

    @Override
    public TOPDriver getProbeDriver() {
        return this.topDriver;
    }
}

