/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.util;

import com.valkyrieofnight.vlib.core.util.math.MathUtil;

public class GridAlignment {
    protected final int boxWidth;
    protected final int boxHeight;
    protected final int xSpace;
    protected final int ySpace;
    protected int alignedLimit;
    protected int space;
    protected Alignment aligned;
    protected int curRow = 0;
    protected int curCol = 0;

    public GridAlignment(int boxWidth, int boxHeight, int xSpace, int ySpace, int alignedLimit, Alignment a) {
        this.boxWidth = boxWidth;
        this.boxHeight = boxHeight;
        this.xSpace = xSpace;
        this.ySpace = ySpace;
        this.aligned = a;
        this.alignedLimit = alignedLimit;
    }

    public int getCurrentRow() {
        return this.curRow;
    }

    public int getCurrentCol() {
        return this.curCol;
    }

    public void next() {
        if (this.aligned == Alignment.VERTICAL) {
            if (this.curCol < this.alignedLimit - 1) {
                ++this.curCol;
            } else {
                this.curCol = 0;
                ++this.curRow;
            }
        } else if (this.curRow < this.alignedLimit - 1) {
            ++this.curRow;
        } else {
            this.curRow = 0;
            ++this.curCol;
        }
    }

    public int getXOffset(int col) {
        int s = MathUtil.clamp(col, 0, Integer.MAX_VALUE) * this.xSpace;
        int x = MathUtil.clamp(col, 0, Integer.MAX_VALUE) * this.boxWidth;
        return x + s;
    }

    public int getYOffset(int row) {
        int s = MathUtil.clamp(row, 0, Integer.MAX_VALUE) * this.ySpace;
        int y = MathUtil.clamp(row, 0, Integer.MAX_VALUE) * this.boxHeight;
        return y + s;
    }

    public int getCurrentXOffset() {
        return this.getXOffset(this.curCol);
    }

    public int getCurrentYOffset() {
        return this.getYOffset(this.curRow);
    }

    public static enum Alignment {
        HORIZONTAL,
        VERTICAL;

    }
}

