/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import org.jetbrains.annotations.NotNull;

public class PropShort
extends PropBase<Short> {
    public static final PropShortParser PARSER = new PropShortParser();
    protected short min;
    protected short max;

    public PropShort(short value, short min, short max) {
        super(value);
        this.min = min;
        this.max = max;
    }

    public PropShort(short value) {
        this(value, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    @Override
    public String getExtra() {
        return "[" + this.min + "~" + this.max + "]";
    }

    @Override
    protected Short validateData(Short data) {
        return MathUtil.clamp(data, this.min, this.max);
    }

    @Override
    public PropParserBase getParser() {
        return PARSER;
    }

    protected static class PropShortParser
    extends PropParserBase<PropShort> {
        public PropShortParser() {
            super("sh");
        }

        @Override
        public PropShort fromJson(@NotNull JsonElement json) throws Exception {
            return new PropShort(json.getAsShort());
        }

        @Override
        public JsonElement toJson(@NotNull PropShort prop) throws Exception {
            return new JsonPrimitive((Number)prop.getValue());
        }
    }
}

