/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.item;

import com.tfar.metalbarrels.item.UpgradeInfo;
import com.tfar.metalbarrels.tile.AbstractBarrelTile;
import java.util.ArrayList;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BarrelUpgradeItem
extends Item {
    public final UpgradeInfo upgradeInfo;

    public BarrelUpgradeItem(Item.Properties properties, UpgradeInfo info) {
        super(properties);
        this.upgradeInfo = info;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        ItemStack heldStack = context.func_195996_i();
        BlockState state = world.func_180495_p(pos);
        if (player == null || !this.upgradeInfo.canUpgrade(world.func_180495_p(pos).func_177230_c())) {
            return ActionResultType.FAIL;
        }
        if (world.field_72995_K || !player.func_70093_af()) {
            return ActionResultType.PASS;
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208193_t)).booleanValue()) {
            player.func_146105_b(new TranslationTextComponent("metalbarrels.in_use", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
            return ActionResultType.PASS;
        }
        TileEntity oldBarrel = world.func_175625_s(pos);
        ArrayList<ItemStack> barrelContents = new ArrayList<ItemStack>();
        if (oldBarrel instanceof AbstractBarrelTile) {
            barrelContents.addAll(((AbstractBarrelTile)oldBarrel).handler.getContents());
        } else {
            oldBarrel.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).forEach(barrelContents::add));
        }
        oldBarrel.func_145836_u();
        oldBarrel.func_145843_s();
        BlockState newState = (BlockState)this.upgradeInfo.end_block.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, state.func_177229_b((IProperty)BlockStateProperties.field_208155_H));
        world.func_180501_a(pos, newState, 3);
        world.func_184138_a(pos, newState, newState, 3);
        TileEntity newBarrel = world.func_175625_s(pos);
        ((AbstractBarrelTile)newBarrel).handler.setContents(barrelContents, ((AbstractBarrelTile)newBarrel).handler.getSlots());
        if (!player.field_71075_bZ.field_75098_d) {
            heldStack.func_190918_g(1);
        }
        player.func_146105_b(new TranslationTextComponent("metalbarrels.upgrade_successful", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), true);
        return ActionResultType.SUCCESS;
    }
}

