/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.item.DiviningRodItem;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="randomthings")
public class ModItems {
    @ObjectHolder(value="fertilized_dirt")
    public static Item FERTILIZED_DIRT;
    @ObjectHolder(value="block_of_sticks")
    public static Item BLOCK_OF_STICKS;
    @ObjectHolder(value="block_of_sticks_returning")
    public static Item BLOCK_OF_STICKS_RETURNING;
    @ObjectHolder(value="rainbow_lamp")
    public static Item RAINBOW_LAMP;
    public static ItemGroup RT_ITEM_GROUP;
    static ArrayList<Color> colorHolder;
    static ArrayList<String> tagHolder;

    public static void registerItems(RegistryEvent.Register<Item> itemRegistryEvent) {
        IForgeRegistry registry = itemRegistryEvent.getRegistry();
        ModItems.registerDiviningRod((IForgeRegistry<Item>)registry, "coal", new Color(20, 20, 20, 50), Tags.Blocks.ORES_COAL.func_199886_b().toString());
        ModItems.registerDiviningRod((IForgeRegistry<Item>)registry, "iron", new Color(211, 180, 159, 50), Tags.Blocks.ORES_IRON.func_199886_b().toString());
        ModItems.registerDiviningRod((IForgeRegistry<Item>)registry, "gold", new Color(246, 233, 80, 50), Tags.Blocks.ORES_GOLD.func_199886_b().toString());
        ModItems.registerDiviningRod((IForgeRegistry<Item>)registry, "lapis", new Color(5, 45, 150, 50), Tags.Blocks.ORES_LAPIS.func_199886_b().toString());
        ModItems.registerDiviningRod((IForgeRegistry<Item>)registry, "redstone", new Color(211, 1, 1, 50), Tags.Blocks.ORES_REDSTONE.func_199886_b().toString());
        ModItems.registerDiviningRod((IForgeRegistry<Item>)registry, "emerald", new Color(0, 220, 0, 50), Tags.Blocks.ORES_EMERALD.func_199886_b().toString());
        ModItems.registerDiviningRod((IForgeRegistry<Item>)registry, "diamond", new Color(87, 221, 229, 50), Tags.Blocks.ORES_DIAMOND.func_199886_b().toString());
        ModItems.registerDiviningRod((IForgeRegistry<Item>)registry, "vanilla", colorHolder.toArray(new Color[0]), tagHolder.toArray(new String[0]));
        tagHolder.clear();
        colorHolder.clear();
        ModItems.registerItemForBlock((IForgeRegistry<Item>)registry, ModBlocks.FERTILIZED_DIRT);
        ModItems.registerItemForBlock((IForgeRegistry<Item>)registry, ModBlocks.RAINBOW_LAMP);
        ModItems.registerItemForBlock((IForgeRegistry<Item>)registry, ModBlocks.SUPER_LUBRICENT_STONE);
        registry.register(new WallOrFloorItem(ModBlocks.ADVANCED_REDSTONE_TORCH, ModBlocks.ADVANCED_WALL_REDSTONE_TORCH, new Item.Properties().func_200916_a(RT_ITEM_GROUP)).setRegistryName(ModBlocks.ADVANCED_REDSTONE_TORCH.getRegistryName()));
        ModItems.registerItemForBlock((IForgeRegistry<Item>)registry, ModBlocks.BLOCK_OF_STICKS, ModBlocks.BLOCK_OF_STICKS_RETURNING);
        ModItems.registerItemForBlock((IForgeRegistry<Item>)registry, ModBlocks.PLATFORM_OAK, ModBlocks.PLATFORM_SPRUCE, ModBlocks.PLATFORM_BIRCH, ModBlocks.PLATFORM_JUNGLE, ModBlocks.PLATFORM_ACACIA, ModBlocks.PLATFORM_DARKOAK);
    }

    private static void registerDiviningRod(IForgeRegistry<Item> registry, String name, Color[] colors, String[] tags) {
        tagHolder.addAll(Arrays.asList(tags));
        colorHolder.addAll(Arrays.asList(colors));
        registry.register(new DiviningRodItem(new Item.Properties().func_200916_a(RT_ITEM_GROUP), colors, tags).setRegistryName("divining_rod_" + name));
    }

    private static void registerDiviningRod(IForgeRegistry<Item> registry, String name, Color color, String tag) {
        ModItems.registerDiviningRod(registry, name, new Color[]{color}, new String[]{tag});
    }

    private static void registerItemForBlock(IForgeRegistry<Item> registry, Block ... blocks) {
        for (Block block : blocks) {
            BlockItem itemInstance = new BlockItem(block, new Item.Properties().func_200916_a(RT_ITEM_GROUP));
            itemInstance.setRegistryName(block.getRegistryName());
            registry.register((IForgeRegistryEntry)itemInstance);
        }
    }

    public static void initItemGroup() {
        RT_ITEM_GROUP = new ItemGroup("randomthings"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModBlocks.FERTILIZED_DIRT);
            }
        };
    }

    static {
        colorHolder = new ArrayList();
        tagHolder = new ArrayList();
    }
}

