/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import lumien.randomthings.tileentity.AdvancedRedstoneTorchTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class AdvancedRedstoneTorchBlock
extends TorchBlock {
    public static final EnumProperty<COLOR> COLOR_PROPERTY = EnumProperty.func_177709_a((String)"color", COLOR.class);
    private static final Map<IBlockReader, List<Toggle>> BURNED_TORCHES = new WeakHashMap<IBlockReader, List<Toggle>>();
    protected RedstoneParticleData GREEN_DUST = new RedstoneParticleData(0.0f, 1.0f, 0.0f, 1.0f);

    protected AdvancedRedstoneTorchBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.0f).func_200951_a(7).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(COLOR_PROPERTY, (Comparable)((Object)COLOR.RED)));
    }

    protected AdvancedRedstoneTorchBlock(Block.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AdvancedRedstoneTorchTileEntity();
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof AdvancedRedstoneTorchTileEntity) {
            AdvancedRedstoneTorchTileEntity art = (AdvancedRedstoneTorchTileEntity)tileentity;
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)art);
        }
        return true;
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 2;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        for (Direction direction : Direction.values()) {
            worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving) {
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        AdvancedRedstoneTorchTileEntity te = (AdvancedRedstoneTorchTileEntity)blockAccess.func_175625_s(pos);
        int strength = blockState.func_177229_b(COLOR_PROPERTY) == COLOR.RED ? te.signalStrengthRed() : te.signalStrengthGreen();
        return Direction.UP != side ? strength : 0;
    }

    protected boolean shouldBeGreen(World worldIn, BlockPos pos, BlockState state) {
        return worldIn.func_175709_b(pos.func_177977_b(), Direction.DOWN);
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        AdvancedRedstoneTorchBlock.update(state, worldIn, pos, random, this.shouldBeGreen(worldIn, pos, state));
    }

    public static void update(BlockState state, World worldIn, BlockPos pos, Random p_196527_3_, boolean p_196527_4_) {
        List<Toggle> list = BURNED_TORCHES.get(worldIn);
        while (list != null && !list.isEmpty() && worldIn.func_82737_E() - list.get(0).time > 60L) {
            list.remove(0);
        }
        if (state.func_177229_b(COLOR_PROPERTY) == COLOR.RED) {
            if (p_196527_4_) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(COLOR_PROPERTY, (Comparable)((Object)COLOR.GREEN)), 3);
                if (AdvancedRedstoneTorchBlock.isBurnedOut(worldIn, pos, true)) {
                    worldIn.func_217379_c(1502, pos, 0);
                    worldIn.func_205220_G_().func_205360_a(pos, (Object)worldIn.func_180495_p(pos).func_177230_c(), 160);
                }
            }
        } else if (!p_196527_4_ && !AdvancedRedstoneTorchBlock.isBurnedOut(worldIn, pos, false)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(COLOR_PROPERTY, (Comparable)((Object)COLOR.RED)), 3);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.func_177229_b(COLOR_PROPERTY) == COLOR.RED == this.shouldBeGreen(worldIn, pos, state) && !worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
        }
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return side == Direction.DOWN ? blockState.func_185911_a(blockAccess, pos, side) : 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (stateIn.func_177229_b(COLOR_PROPERTY) == COLOR.RED) {
            double d0 = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pos.func_177956_o() + 0.7 + (rand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            worldIn.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, d0, d1, d2, 0.0, 0.0, 0.0);
        } else {
            double d0 = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pos.func_177956_o() + 0.7 + (rand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            worldIn.func_195594_a((IParticleData)this.GREEN_DUST, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{COLOR_PROPERTY});
    }

    private static boolean isBurnedOut(World p_176598_0_, BlockPos worldIn, boolean pos) {
        List list = BURNED_TORCHES.computeIfAbsent((IBlockReader)p_176598_0_, p_220288_0_ -> Lists.newArrayList());
        if (pos) {
            list.add(new Toggle(worldIn.func_185334_h(), p_176598_0_.func_82737_E()));
        }
        int i = 0;
        for (int j = 0; j < list.size(); ++j) {
            Toggle redstonetorchblock$toggle = (Toggle)list.get(j);
            if (!redstonetorchblock$toggle.pos.equals((Object)worldIn) || ++i < 8) continue;
            return true;
        }
        return false;
    }

    public static class Toggle {
        private final BlockPos pos;
        private final long time;

        public Toggle(BlockPos pos, long time) {
            this.pos = pos;
            this.time = time;
        }
    }

    public static enum COLOR implements IStringSerializable
    {
        GREEN,
        RED;


        public String func_176610_l() {
            return this == GREEN ? "green" : "red";
        }
    }
}

