/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.addons.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.kaneka.planttech2.addons.jei.RecipeGetter;
import net.kaneka.planttech2.addons.jei.chipalyzer.ChipalyzerCategory;
import net.kaneka.planttech2.addons.jei.compressor.CompressorCategory;
import net.kaneka.planttech2.addons.jei.crossbreeding.CrossbreedingCategory;
import net.kaneka.planttech2.addons.jei.infuser.InfuserCategory;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class PlantTech2Plugin
implements IModPlugin {
    private CompressorCategory compressorCategory;
    private CrossbreedingCategory crossbreedingCategory;
    private InfuserCategory infuserCategory;
    private ChipalyzerCategory chipalyzerCategory;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jei", "planttech2");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        this.compressorCategory = new CompressorCategory(guiHelper);
        this.crossbreedingCategory = new CrossbreedingCategory(guiHelper);
        this.infuserCategory = new InfuserCategory(guiHelper);
        this.chipalyzerCategory = new ChipalyzerCategory(guiHelper);
        registration.addRecipeCategories(new IRecipeCategory[]{this.compressorCategory, this.crossbreedingCategory, this.infuserCategory, this.chipalyzerCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeGetter.getCompressorRecipes(), new ResourceLocation("planttech2", "compressor"));
        registration.addRecipes(RecipeGetter.getCrossbreedingRecipes(), new ResourceLocation("planttech2", "crossbreeding"));
        registration.addRecipes(RecipeGetter.getInfuserRecipes(), new ResourceLocation("planttech2", "infuser"));
        registration.addRecipes(RecipeGetter.getChipalyzerRecipes(), new ResourceLocation("planttech2", "chipalyzer"));
    }
}

