/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.base.TileEntityBase;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTileData {
    private int field;
    private int value;
    private BlockPos pos;

    public PacketTileData(int field, int value, BlockPos pos) {
        this.field = field;
        this.value = value;
        this.pos = pos;
    }

    public PacketTileData() {
    }

    public static void handle(PacketTileData message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.func_130014_f_();
            TileEntity tile = world.func_175625_s(message.pos);
            if (tile instanceof TileEntityBase) {
                TileEntityBase base = (TileEntityBase)tile;
                base.setField(message.field, message.value);
            }
        });
    }

    public static PacketTileData decode(PacketBuffer buf) {
        PacketTileData p = new PacketTileData();
        p.field = buf.readInt();
        p.value = buf.readInt();
        CompoundNBT tags = buf.func_150793_b();
        p.pos = new BlockPos(tags.func_74762_e("x"), tags.func_74762_e("y"), tags.func_74762_e("z"));
        return p;
    }

    public static void encode(PacketTileData msg, PacketBuffer buf) {
        buf.writeInt(msg.field);
        buf.writeInt(msg.value);
        CompoundNBT tags = new CompoundNBT();
        tags.func_74768_a("x", msg.pos.func_177958_n());
        tags.func_74768_a("y", msg.pos.func_177956_o());
        tags.func_74768_a("z", msg.pos.func_177952_p());
        buf.func_150786_a(tags);
    }
}

