/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.expcollect;

import com.lothrazar.cyclic.CyclicRegistry;
import com.lothrazar.cyclic.base.TileEntityBase;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileExpPylon
extends TileEntityBase
implements ITickableTileEntity {
    private static final int RADIUS = 8;
    private static final int MAX = 4096;
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);
    private int storedXp;

    public TileExpPylon() {
        super(CyclicRegistry.experience_pylontile);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(2);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145839_a(CompoundNBT tag) {
        this.setStoredXp(tag.func_74762_e("storedXp"));
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)invTag));
        super.func_145839_a(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("storedXp", this.getStoredXp());
        this.handler.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List list = this.field_145850_b.func_175647_a(ExperienceOrbEntity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 8), (double)(this.field_174879_c.func_177956_o() - 1), (double)(this.field_174879_c.func_177952_p() - 8), (double)(this.field_174879_c.func_177958_n() + 8), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 8)), entity -> entity.func_70089_S() && entity.func_70526_d() > 0);
        if (list.size() > 0) {
            ExperienceOrbEntity myOrb = (ExperienceOrbEntity)list.get(this.field_145850_b.field_73012_v.nextInt(list.size()));
            int addMe = myOrb.func_70526_d();
            if (this.getStoredXp() + addMe <= 4096) {
                myOrb.field_70530_e = 0;
                myOrb.func_70106_y();
                this.setStoredXp(this.getStoredXp() + addMe);
            }
        }
    }

    public int getStoredXp() {
        return this.storedXp;
    }

    public boolean drainStoredXp(int drainMe) {
        if (drainMe > this.getStoredXp()) {
            return false;
        }
        this.setStoredXp(this.getStoredXp() - drainMe);
        return true;
    }

    public void setStoredXp(int storedXp) {
        this.storedXp = storedXp;
    }

    @Override
    public void setField(int field, int value) {
    }
}

