/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.CyclicRegistry;
import com.lothrazar.cyclic.base.CustomEnergyStorage;
import com.lothrazar.cyclic.base.TileEntityBase;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileCableEnergy
extends TileEntityBase
implements ITickableTileEntity {
    private Map<Direction, Integer> mapIncomingEnergy = Maps.newHashMap();
    private static final int MAX = 8000;
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    private static final int TIMER_SIDE_INPUT = 15;

    public TileCableEnergy() {
        super(CyclicRegistry.energy_pipeTile);
        for (Direction f : Direction.values()) {
            this.mapIncomingEnergy.put(f, 0);
        }
    }

    public void func_73660_a() {
        this.tickDownIncomingPowerFaces();
        this.tickCableFlow();
    }

    private void tickCableFlow() {
        List rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());
        Collections.shuffle(rawList);
        for (Integer i : rawList) {
            Direction exportToSide = Direction.values()[i];
            if (this.isEnergyIncomingFromFace(exportToSide)) continue;
            this.moveEnergy(exportToSide, 8000);
        }
    }

    public void tickDownIncomingPowerFaces() {
        for (Direction f : Direction.values()) {
            if (this.mapIncomingEnergy.get(f) <= 0) continue;
            this.mapIncomingEnergy.put(f, this.mapIncomingEnergy.get(f) - 1);
        }
    }

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(8000, 8000);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145839_a(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            this.mapIncomingEnergy.put(f, tag.func_74762_e(f.func_176610_l() + "_incenergy"));
        }
        CompoundNBT energyTag = tag.func_74775_l("energy");
        this.energy.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)energyTag));
        super.func_145839_a(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            tag.func_74768_a(f.func_176610_l() + "_incenergy", this.mapIncomingEnergy.get(f).intValue());
        }
        this.energy.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("energy", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    private boolean isEnergyIncomingFromFace(Direction face) {
        return this.mapIncomingEnergy.get(face) > 0;
    }

    public void updateIncomingEnergyFace(Direction inputFrom) {
        this.mapIncomingEnergy.put(inputFrom, 15);
    }

    @Override
    public void setField(int field, int value) {
    }
}

