/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerTileEntity;
import mcjty.rftools.network.PacketGetPlayers;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiEnvironmentalController
extends GenericGuiContainer<EnvironmentalControllerTileEntity> {
    public static final String BLACKLIST = "BL";
    public static final String WHITELIST = "WL";
    public static final String HOSTILE = "Host";
    public static final String PASSIVE = "Pass";
    public static final String MOBS = "Mobs";
    public static final String ALL = "All";
    private List<String> players = null;
    private int listDirty = 0;
    private EnergyBar energyBar;
    private TextField minyTextField;
    private TextField maxyTextField;
    private TextField nameField;
    private WidgetList playersList;
    private ChoiceLabel modeLabel;

    public GuiEnvironmentalController(EnvironmentalControllerTileEntity tileEntity, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)tileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "envctrl");
    }

    public void func_73866_w_() {
        this.window = new Window((GuiScreen)this, this.tileEntity, RFToolsMessages.INSTANCE, new ResourceLocation("rftools", "gui/environmental.gui"));
        super.func_73866_w_();
        this.initializeFields();
        this.setupEvents();
        this.listDirty = 0;
        this.requestPlayers();
    }

    private void initializeFields() {
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.energyBar.setMaxValue(((EnvironmentalControllerTileEntity)this.tileEntity).getCapacity());
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        ((ImageChoiceLabel)this.window.findChild("redstone")).setCurrentChoice(((EnvironmentalControllerTileEntity)this.tileEntity).getRSMode().ordinal());
        int r = ((EnvironmentalControllerTileEntity)this.tileEntity).getRadius();
        if (r < 5) {
            r = 5;
        } else if (r > 100) {
            r = 100;
        }
        ((ScrollableLabel)this.window.findChild("radius")).setRealValue(r);
        this.playersList = (WidgetList)this.window.findChild("players");
        this.minyTextField = (TextField)this.window.findChild("miny");
        this.maxyTextField = (TextField)this.window.findChild("maxy");
        this.nameField = (TextField)this.window.findChild("name");
        this.modeLabel = (ChoiceLabel)this.window.findChild("mode");
        this.minyTextField.setText(Integer.toString(((EnvironmentalControllerTileEntity)this.tileEntity).getMiny()));
        this.maxyTextField.setText(Integer.toString(((EnvironmentalControllerTileEntity)this.tileEntity).getMaxy()));
        switch (((EnvironmentalControllerTileEntity)this.tileEntity).getMode()) {
            case MODE_BLACKLIST: {
                this.modeLabel.setChoice(BLACKLIST);
                break;
            }
            case MODE_WHITELIST: {
                this.modeLabel.setChoice(WHITELIST);
                break;
            }
            case MODE_HOSTILE: {
                this.modeLabel.setChoice(HOSTILE);
                break;
            }
            case MODE_PASSIVE: {
                this.modeLabel.setChoice(PASSIVE);
                break;
            }
            case MODE_MOBS: {
                this.modeLabel.setChoice(MOBS);
                break;
            }
            case MODE_ALL: {
                this.modeLabel.setChoice(ALL);
            }
        }
    }

    private void setupEvents() {
        this.window.event("add", (source, params) -> this.addPlayer());
        this.window.event("del", (source, params) -> this.delPlayer());
        this.window.event("mode", (source, params) -> this.changeMode((String)params.get(ChoiceLabel.PARAM_CHOICE)));
        this.window.event("miny", (source, params) -> this.sendBounds(true));
        this.window.event("maxy", (source, params) -> this.sendBounds(false));
    }

    private void changeMode(String newAccess) {
        EnvironmentalControllerTileEntity.EnvironmentalMode newmode = ALL.equals(newAccess) ? EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_ALL : (BLACKLIST.equals(newAccess) ? EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_BLACKLIST : (WHITELIST.equals(newAccess) ? EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_WHITELIST : (MOBS.equals(newAccess) ? EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_MOBS : (PASSIVE.equals(newAccess) ? EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_PASSIVE : EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_HOSTILE))));
        this.sendServerCommand(RFToolsMessages.INSTANCE, "env.setBlacklist", TypedMap.builder().put(EnvironmentalControllerTileEntity.PARAM_MODE, (Object)newmode.ordinal()).build());
    }

    private void addPlayer() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "env.addPlayer", TypedMap.builder().put(EnvironmentalControllerTileEntity.PARAM_NAME, (Object)this.nameField.getText()).build());
        this.listDirty = 0;
    }

    private void delPlayer() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "env.delPlayer", TypedMap.builder().put(EnvironmentalControllerTileEntity.PARAM_NAME, (Object)this.players.get(this.playersList.getSelected())).build());
        this.listDirty = 0;
    }

    private void requestPlayers() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetPlayers(((EnvironmentalControllerTileEntity)this.tileEntity).func_174877_v(), "getPlayers", "getPlayers"));
    }

    private void populatePlayers() {
        this.players = new ArrayList<String>(((EnvironmentalControllerTileEntity)this.tileEntity).players);
        this.players.sort(null);
        this.playersList.removeChildren();
        for (String player : this.players) {
            this.playersList.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(player)).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        }
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestPlayers();
            this.listDirty = 20;
        }
    }

    private void sendBounds(boolean minchanged) {
        int maxy;
        int miny;
        try {
            miny = Integer.parseInt(this.minyTextField.getText());
        }
        catch (NumberFormatException e) {
            miny = 0;
        }
        try {
            maxy = Integer.parseInt(this.maxyTextField.getText());
        }
        catch (NumberFormatException e) {
            maxy = 0;
        }
        if (minchanged) {
            if (miny > maxy) {
                maxy = miny;
                this.maxyTextField.setText(Integer.toString(maxy));
            }
        } else if (miny > maxy) {
            miny = maxy;
            this.minyTextField.setText(Integer.toString(miny));
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "env.setBounds", TypedMap.builder().put(EnvironmentalControllerTileEntity.PARAM_MIN, (Object)miny).put(EnvironmentalControllerTileEntity.PARAM_MAX, (Object)maxy).build());
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.requestListsIfNeeded();
        this.populatePlayers();
        this.enableButtons();
        long currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((EnvironmentalControllerTileEntity)this.tileEntity).requestRfFromServer("rftools");
        this.drawWindow();
    }

    private void enableButtons() {
        this.window.setFlag("selected", this.playersList.getSelected() != -1);
        String name = this.nameField.getText();
        this.window.setFlag("name", name != null && !name.isEmpty());
    }
}

