/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element.view;

import java.util.OptionalInt;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.UIElement;
import net.shadowfacts.shadowmc.ui.element.view.UIView;
import net.shadowfacts.shadowmc.ui.style.UIAttribute;
import net.shadowfacts.shadowmc.ui.style.UIOrientation;

public class UIStackView
extends UIView {
    public UIStackView(String id, String ... classes) {
        super("stack", id, classes);
    }

    @Override
    public void layout(int minX, int maxX, int minY, int maxY) {
        super.layout(minX, maxX, minY, maxY);
        UIOrientation stackMode = this.getStyle(UIAttribute.ORIENTATION);
        int spacing = this.getStyle(UIAttribute.STACK_SPACING);
        if (stackMode == UIOrientation.VERTICAL) {
            int currentY = 0;
            for (UIElement e : this.children) {
                UIDimensions elementDimensions = e.getPreferredDimensions();
                e.layout(0, this.dimensions.width, currentY, currentY + elementDimensions.height);
                e.setX(this.x + e.getX());
                e.setY(this.y + currentY);
                currentY += elementDimensions.height + spacing;
            }
        } else {
            int currentX = 0;
            for (UIElement e : this.children) {
                UIDimensions elementDimensions = e.getPreferredDimensions();
                e.layout(currentX, currentX + elementDimensions.width, 0, this.dimensions.height);
                e.setX(this.x + currentX);
                e.setY(this.y + e.getY());
                currentX += elementDimensions.width + spacing;
            }
        }
    }

    @Override
    public UIDimensions getMinDimensions() {
        return this.getPreferredDimensions();
    }

    @Override
    public UIDimensions getPreferredDimensions() {
        UIOrientation stackMode = this.getStyle(UIAttribute.ORIENTATION);
        int spacing = this.getStyle(UIAttribute.STACK_SPACING);
        if (stackMode == UIOrientation.VERTICAL) {
            OptionalInt width = this.children.stream().map(UIElement::getPreferredDimensions).mapToInt(dimensions -> dimensions.width).max();
            if (width.isPresent()) {
                int height = this.children.stream().map(UIElement::getPreferredDimensions).mapToInt(dimensions -> dimensions.height).map(i -> i + spacing).sum() - spacing;
                return new UIDimensions(width.getAsInt(), height);
            }
            return new UIDimensions(0, 0);
        }
        OptionalInt height = this.children.stream().map(UIElement::getPreferredDimensions).mapToInt(dimensions -> dimensions.height).max();
        if (height.isPresent()) {
            int width = this.children.stream().map(UIElement::getPreferredDimensions).mapToInt(dimensions -> dimensions.width).map(i -> i + spacing).sum() - spacing;
            return new UIDimensions(width, height.getAsInt());
        }
        return new UIDimensions(0, 0);
    }
}

