/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.tile;

import com.buuz135.portality.block.BlockController;
import com.buuz135.portality.block.module.IPortalModule;
import com.buuz135.portality.data.PortalDataManager;
import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.data.PortalLinkData;
import com.buuz135.portality.handler.ChunkLoaderHandler;
import com.buuz135.portality.handler.CustomEnergyStorageHandler;
import com.buuz135.portality.handler.StructureHandler;
import com.buuz135.portality.handler.TeleportHandler;
import com.buuz135.portality.proxy.PortalityConfig;
import com.buuz135.portality.proxy.PortalitySoundHandler;
import com.buuz135.portality.proxy.client.TickeableSound;
import com.buuz135.portality.tile.TileBase;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileController
extends TileBase
implements ITickable {
    private static String NBT_FORMED = "Formed";
    private static String NBT_LENGTH = "Length";
    private static String NBT_WIDTH = "Width";
    private static String NBT_HEIGHT = "Height";
    private static String NBT_PORTAL = "Portal";
    private static String NBT_LINK = "Link";
    private static String NBT_DISPLAY = "Display";
    private static String NBT_ONCE = "Once";
    private boolean isFormed = false;
    private boolean onceCall = false;
    private boolean display = true;
    private PortalInformation information;
    private PortalLinkData linkData;
    private CustomEnergyStorageHandler energy;
    @SideOnly(value=Side.CLIENT)
    private TickeableSound sound;
    private TeleportHandler teleportHandler = new TeleportHandler(this);
    private StructureHandler structureHandler = new StructureHandler(this);

    public TileController() {
        this.energy = new CustomEnergyStorageHandler(PortalityConfig.MAX_PORTAL_POWER, PortalityConfig.MAX_PORTAL_POWER_IN, 0, 0);
    }

    public void func_73660_a() {
        if (this.isActive()) {
            this.teleportHandler.tick();
            if (this.linkData != null) {
                for (Entity entity : this.field_145850_b.func_72872_a(Entity.class, this.getPortalArea())) {
                    this.teleportHandler.addEntityToTeleport(entity, this.linkData);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.workModules();
        }
        if (this.field_145850_b.field_72995_K) {
            this.tickSound();
            return;
        }
        if (this.isActive() && this.linkData != null) {
            this.energy.extractEnergyInternal((this.linkData.isCaller() ? 2 : 1) * this.structureHandler.getLength() * PortalityConfig.POWER_PORTAL_TICK, false);
            if (this.energy.getEnergyStored() == 0 || !this.isFormed) {
                this.closeLink();
            }
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            if (this.structureHandler.shouldCheckForStructure()) {
                this.isFormed = this.structureHandler.checkArea();
                if (this.isFormed) {
                    this.structureHandler.setShouldCheckForStructure(false);
                } else {
                    this.structureHandler.cancelFrameBlocks();
                }
            }
            if (this.isFormed) {
                this.getPortalInfo();
                if (this.linkData != null) {
                    ChunkLoaderHandler.addPortalAsChunkloader(this);
                    TileEntity tileEntity = this.field_145850_b.func_73046_m().func_71218_a(this.linkData.getDimension()).func_175625_s(this.linkData.getPos());
                    if (!(tileEntity instanceof TileController) || ((TileController)tileEntity).getLinkData() == null || ((TileController)tileEntity).getLinkData().getDimension() != this.field_145850_b.field_73011_w.getDimension() || !((TileController)tileEntity).getLinkData().getPos().equals((Object)this.field_174879_c)) {
                        this.closeLink();
                    }
                }
            }
            this.markForUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void tickSound() {
        if (this.isActive()) {
            if (this.sound == null) {
                this.sound = new TickeableSound(this.field_145850_b, this.field_174879_c, PortalitySoundHandler.PORTAL);
                FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
            } else {
                this.sound.increase();
            }
        } else if (this.sound != null) {
            if (this.sound.func_147655_f() > 0.0f) {
                this.sound.decrease();
            } else {
                this.sound.setDone();
                this.sound = null;
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74757_a(NBT_FORMED, this.isFormed);
        compound.func_74768_a(NBT_LENGTH, this.structureHandler.getLength());
        compound.func_74768_a(NBT_WIDTH, this.structureHandler.getWidth());
        compound.func_74768_a(NBT_HEIGHT, this.structureHandler.getHeight());
        this.energy.writeToNBT(compound);
        compound.func_74757_a(NBT_ONCE, this.onceCall);
        compound.func_74757_a(NBT_DISPLAY, this.display);
        if (this.information != null) {
            compound.func_74782_a(NBT_PORTAL, (NBTBase)this.information.writetoNBT());
        }
        if (this.linkData != null) {
            compound.func_74782_a(NBT_LINK, (NBTBase)this.linkData.writeToNBT());
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.isFormed = compound.func_74767_n(NBT_FORMED);
        this.structureHandler.setLength(compound.func_74762_e(NBT_LENGTH));
        this.structureHandler.setWidth(compound.func_74762_e(NBT_WIDTH));
        this.structureHandler.setHeight(compound.func_74762_e(NBT_HEIGHT));
        if (compound.func_74764_b(NBT_PORTAL)) {
            this.information = PortalInformation.readFromNBT(compound.func_74775_l(NBT_PORTAL));
        }
        if (compound.func_74764_b(NBT_LINK)) {
            this.linkData = PortalLinkData.readFromNBT(compound.func_74775_l(NBT_LINK));
        }
        this.energy.readFromNBT(compound);
        this.onceCall = compound.func_74767_n(NBT_ONCE);
        this.display = compound.func_74767_n(NBT_DISPLAY);
        super.func_145839_a(compound);
    }

    public void breakController() {
        this.closeLink();
        this.structureHandler.cancelFrameBlocks();
    }

    private void workModules() {
        boolean interdimensional = false;
        for (BlockPos pos : this.structureHandler.getModules()) {
            Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
            if (!(block instanceof IPortalModule)) continue;
            if (((IPortalModule)block).allowsInterdimensionalTravel()) {
                interdimensional = true;
            }
            if (!this.isActive()) continue;
            ((IPortalModule)block).work(this, pos);
        }
        PortalDataManager.setPortalInterdimensional(this.field_145850_b, this.field_174879_c, interdimensional);
    }

    public AxisAlignedBB getPortalArea() {
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockController)) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockController.FACING);
        BlockPos corner1 = this.field_174879_c.func_177967_a(facing.func_176746_e(), this.structureHandler.getWidth() - 1).func_177972_a(EnumFacing.UP);
        BlockPos corner2 = this.field_174879_c.func_177967_a(facing.func_176746_e(), -this.structureHandler.getWidth() + 1).func_177967_a(EnumFacing.UP, this.structureHandler.getHeight() - 1).func_177967_a(facing.func_176734_d(), this.structureHandler.getLength() - 1);
        return new AxisAlignedBB(corner1, corner2);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getPortalArea();
    }

    private void getPortalInfo() {
        this.information = PortalDataManager.getInfoFromPos(this.field_145850_b, this.field_174879_c);
    }

    public void togglePrivacy() {
        PortalDataManager.setPortalPrivacy(this.field_145850_b, this.field_174879_c, !this.information.isPrivate());
        this.getPortalInfo();
        this.markForUpdate();
    }

    public boolean isFormed() {
        return this.isFormed;
    }

    public boolean isPrivate() {
        return this.information != null && this.information.isPrivate();
    }

    public UUID getOwner() {
        if (this.information != null) {
            return this.information.getOwner();
        }
        return null;
    }

    public UUID getID() {
        if (this.information != null) {
            return this.information.getId();
        }
        return null;
    }

    public String getName() {
        if (this.information != null) {
            return this.information.getName();
        }
        return "";
    }

    public void setName(String name) {
        PortalDataManager.setPortalName(this.field_145850_b, this.func_174877_v(), name);
        this.getPortalInfo();
        this.markForUpdate();
    }

    public boolean isInterdimensional() {
        return this.information != null && this.information.isInterdimensional();
    }

    public ItemStack getDisplay() {
        if (this.information != null) {
            return this.information.getDisplay();
        }
        return ItemStack.field_190927_a;
    }

    public void setDisplayNameEnabled(ItemStack display) {
        PortalDataManager.setPortalDisplay(this.field_145850_b, this.field_174879_c, display);
        this.getPortalInfo();
        this.markForUpdate();
    }

    public void linkTo(PortalLinkData data, PortalLinkData.PortalCallType type) {
        WorldServer world;
        TileEntity entity;
        if (type == PortalLinkData.PortalCallType.FORCE) {
            this.closeLink();
        }
        if (this.linkData != null) {
            return;
        }
        if (type == PortalLinkData.PortalCallType.SINGLE) {
            this.onceCall = true;
        }
        if (data.isCaller() && (entity = (world = this.field_145850_b.func_73046_m().func_71218_a(data.getDimension())).func_175625_s(data.getPos())) instanceof TileController) {
            data.setName(((TileController)entity).getName());
            ((TileController)entity).linkTo(new PortalLinkData(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c, false, this.getName()), type);
            int power = PortalityConfig.PORTAL_POWER_OPEN_INTERDIMENSIONAL;
            if (entity.func_145831_w().equals(this.field_145850_b)) {
                power = (int)this.field_174879_c.func_185332_f(entity.func_174877_v().func_177958_n(), entity.func_174877_v().func_177952_p(), entity.func_174877_v().func_177956_o()) * this.structureHandler.getLength();
            }
            this.energy.extractEnergyInternal(power, false);
        }
        PortalDataManager.setActiveStatus(this.field_145850_b, this.field_174879_c, true);
        this.linkData = data;
    }

    public void closeLink() {
        if (this.linkData != null) {
            PortalDataManager.setActiveStatus(this.field_145850_b, this.field_174879_c, false);
            WorldServer world = this.field_145850_b.func_73046_m().func_71218_a(this.linkData.getDimension());
            TileEntity entity = world.func_175625_s(this.linkData.getPos());
            this.linkData = null;
            if (entity instanceof TileController) {
                ((TileController)entity).closeLink();
            }
        }
        ChunkLoaderHandler.removePortalAsChunkloader(this);
    }

    public boolean isActive() {
        return this.information != null && this.information.isActive();
    }

    public PortalLinkData getLinkData() {
        return this.linkData;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public CustomEnergyStorageHandler getEnergy() {
        return this.energy;
    }

    public boolean isDisplayNameEnabled() {
        return this.display;
    }

    public void setDisplayNameEnabled(boolean display) {
        this.display = display;
    }

    public List<BlockPos> getModules() {
        return this.structureHandler.getModules();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energy);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean teleportedEntity() {
        if (this.onceCall) {
            this.onceCall = false;
            this.closeLink();
            return true;
        }
        return false;
    }

    public boolean isShouldCheckForStructure() {
        return this.structureHandler.shouldCheckForStructure();
    }

    public void setShouldCheckForStructure(boolean shouldCheckForStructure) {
        this.structureHandler.setShouldCheckForStructure(shouldCheckForStructure);
    }

    public int getWidth() {
        return this.structureHandler.getWidth();
    }

    public int getHeight() {
        return this.structureHandler.getHeight();
    }

    public int getLength() {
        return this.structureHandler.getLength();
    }
}

