/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters;

import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.transmitters.grid.InventoryNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TransporterImpl
extends TransmitterImpl<TileEntity, InventoryNetwork>
implements ILogisticalTransporter {
    public HashList<TransporterStack> transit = new HashList();
    public EnumColor color;
    public Set<TransporterStack> needsSync = new HashSet<TransporterStack>();

    public TransporterImpl(TileEntityLogisticalTransporter multiPart) {
        super(multiPart);
    }

    public void update() {
        if (this.world().field_72995_K) {
            for (TransporterStack stack : this.transit) {
                if (stack == null) continue;
                stack.progress = Math.min(100, stack.progress + this.getTileEntity().tier.getSpeed());
            }
        } else {
            if (this.getTransmitterNetwork() == null) {
                return;
            }
            HashSet<TransporterStack> remove = new HashSet<TransporterStack>();
            this.getTileEntity().pullItems();
            for (TransporterStack stack : this.transit) {
                if (!(stack.initiatedPath || !stack.itemStack.func_190926_b() && this.recalculate(stack, null))) {
                    remove.add(stack);
                    continue;
                }
                stack.progress += this.getTileEntity().tier.getSpeed();
                if (stack.progress > 100) {
                    Coord4D prevSet = null;
                    if (stack.hasPath()) {
                        int currentIndex = stack.getPath().indexOf(this.coord());
                        if (currentIndex == 0) {
                            remove.add(stack);
                            continue;
                        }
                        Coord4D next = stack.getPath().get(currentIndex - 1);
                        if (!stack.isFinal(this)) {
                            if (next != null && stack.canInsertToTransporter(stack.getNext(this).getTileEntity((IBlockAccess)this.world()), stack.getSide(this))) {
                                ILogisticalTransporter nextTile = CapabilityUtils.getCapability((ICapabilityProvider)next.getTileEntity((IBlockAccess)this.world()), Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null);
                                nextTile.entityEntering(stack, stack.progress % 100);
                                remove.add(stack);
                                continue;
                            }
                            if (next != null) {
                                prevSet = next;
                            }
                        } else if (stack.pathType != TransporterStack.Path.NONE) {
                            TileEntity tile = next.getTileEntity((IBlockAccess)this.world());
                            if (next != null && tile != null) {
                                this.needsSync.add(stack);
                                TransitRequest.TransitResponse response = InventoryUtils.putStackInInventory(tile, TransitRequest.getFromTransport(stack), stack.getSide(this), stack.pathType == TransporterStack.Path.HOME);
                                if (response.getRejected(stack.itemStack).func_190926_b()) {
                                    TransporterManager.remove(stack);
                                    remove.add(stack);
                                    continue;
                                }
                                this.needsSync.add(stack);
                                stack.itemStack = response.getRejected(stack.itemStack);
                                prevSet = next;
                            }
                        }
                    }
                    if (!this.recalculate(stack, prevSet)) {
                        remove.add(stack);
                        continue;
                    }
                    if (prevSet != null) {
                        stack.progress = 0;
                        continue;
                    }
                    stack.progress = 50;
                    continue;
                }
                if (stack.progress != 50) continue;
                if (stack.isFinal(this)) {
                    if (!(stack.pathType != TransporterStack.Path.DEST || this.checkSideForInsert(stack) && InventoryUtils.canInsert(stack.getDest().getTileEntity((IBlockAccess)this.world()), stack.color, stack.itemStack, stack.getSide(this), false))) {
                        if (this.recalculate(stack, null)) continue;
                        remove.add(stack);
                        continue;
                    }
                    if (!(stack.pathType != TransporterStack.Path.HOME || this.checkSideForInsert(stack) && InventoryUtils.canInsert(stack.getDest().getTileEntity((IBlockAccess)this.world()), stack.color, stack.itemStack, stack.getSide(this), true))) {
                        if (this.recalculate(stack, null)) continue;
                        remove.add(stack);
                        continue;
                    }
                    if (stack.pathType != TransporterStack.Path.NONE || this.recalculate(stack, null)) continue;
                    remove.add(stack);
                    continue;
                }
                TileEntity next = stack.getNext(this).getTileEntity((IBlockAccess)this.world());
                boolean recalculate = false;
                if (!stack.canInsertToTransporter(next, stack.getSide(this))) {
                    recalculate = true;
                }
                if (!recalculate || this.recalculate(stack, null)) continue;
                remove.add(stack);
            }
            for (TransporterStack stack : remove) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(this.coord(), this.getTileEntity().getSyncPacket(stack, true)), new Range4D(this.coord()));
                this.transit.remove(stack);
                MekanismUtils.saveChunk(this.getTileEntity());
            }
            for (TransporterStack stack : this.needsSync) {
                if (!this.transit.contains(stack)) continue;
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(this.coord(), this.getTileEntity().getSyncPacket(stack, false)), new Range4D(this.coord()));
            }
            this.needsSync.clear();
        }
    }

    private boolean checkSideForInsert(TransporterStack stack) {
        EnumFacing side = stack.getSide(this);
        return this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL || this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.PUSH;
    }

    private boolean recalculate(TransporterStack stack, Coord4D from) {
        this.needsSync.add(stack);
        if (stack.pathType != TransporterStack.Path.NONE) {
            TransitRequest.TransitResponse ret = stack.recalculatePath(TransitRequest.getFromTransport(stack), this, 0);
            if (ret.isEmpty() && !stack.calculateIdle(this)) {
                TransporterUtils.drop(this, stack);
                return false;
            }
        } else if (!stack.calculateIdle(this)) {
            TransporterUtils.drop(this, stack);
            return false;
        }
        if (from != null) {
            stack.originalLocation = from;
        }
        return true;
    }

    @Override
    public TransitRequest.TransitResponse insert(Coord4D original, TransitRequest request, EnumColor color, boolean doEmit, int min) {
        return this.insert_do(original, request, color, doEmit, min, false);
    }

    private TransitRequest.TransitResponse insert_do(Coord4D original, TransitRequest request, EnumColor color, boolean doEmit, int min, boolean force) {
        EnumFacing from = this.coord().sideDifference(original).func_176734_d();
        TransporterStack stack = new TransporterStack();
        stack.originalLocation = original;
        stack.homeLocation = original;
        stack.color = color;
        if (force && !this.canReceiveFrom(original.getTileEntity((IBlockAccess)this.world()), from) || !stack.canInsertToTransporter(this, from)) {
            return TransitRequest.TransitResponse.EMPTY;
        }
        TransitRequest.TransitResponse response = stack.recalculatePath(request, this, min);
        if (!response.isEmpty()) {
            stack.itemStack = response.stack;
            if (doEmit) {
                this.transit.add(stack);
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(this.coord(), this.getTileEntity().getSyncPacket(stack, false)), new Range4D(this.coord()));
                MekanismUtils.saveChunk(this.getTileEntity());
            }
            return response;
        }
        return TransitRequest.TransitResponse.EMPTY;
    }

    @Override
    public TransitRequest.TransitResponse insertRR(TileEntityLogisticalSorter outputter, TransitRequest request, EnumColor color, boolean doEmit, int min) {
        EnumFacing from = this.coord().sideDifference(Coord4D.get(outputter)).func_176734_d();
        TransporterStack stack = new TransporterStack();
        stack.originalLocation = Coord4D.get(outputter);
        stack.homeLocation = Coord4D.get(outputter);
        stack.color = color;
        if (!this.canReceiveFrom(outputter, from) || !stack.canInsertToTransporter(this, from)) {
            return TransitRequest.TransitResponse.EMPTY;
        }
        TransitRequest.TransitResponse response = stack.recalculateRRPath(request, outputter, this, min);
        if (!response.isEmpty()) {
            stack.itemStack = response.stack;
            if (doEmit) {
                this.transit.add(stack);
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(this.coord(), this.getTileEntity().getSyncPacket(stack, false)), new Range4D(this.coord()));
                MekanismUtils.saveChunk(this.getTileEntity());
            }
            return response;
        }
        return TransitRequest.TransitResponse.EMPTY;
    }

    @Override
    public void entityEntering(TransporterStack stack, int progress) {
        stack.progress = progress;
        this.transit.add(stack);
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(this.coord(), this.getTileEntity().getSyncPacket(stack, false)), new Range4D(this.coord()));
        MekanismUtils.saveChunk(this.getTileEntity());
    }

    @Override
    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(EnumColor c) {
        this.color = c;
    }

    @Override
    public boolean canEmitTo(TileEntity tileEntity, EnumFacing side) {
        if (!this.getTileEntity().canConnect(side)) {
            return false;
        }
        return this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL || this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.PUSH;
    }

    @Override
    public boolean canReceiveFrom(TileEntity tileEntity, EnumFacing side) {
        if (!this.getTileEntity().canConnect(side)) {
            return false;
        }
        return this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL;
    }

    @Override
    public double getCost() {
        return this.getTileEntity().getCost();
    }

    @Override
    public boolean canConnectMutual(EnumFacing side) {
        return this.getTileEntity().canConnectMutual(side);
    }

    @Override
    public boolean canConnect(EnumFacing side) {
        return this.getTileEntity().canConnect(side);
    }

    public TileEntityLogisticalTransporter getTileEntity() {
        return (TileEntityLogisticalTransporter)this.containingTile;
    }
}

