/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.api.TileNetworkList;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.assemblicator.RecipeFormula;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityFormulaicAssemblicator
extends TileEntityElectricBlock
implements ISideConfiguration,
IUpgradeTile,
IRedstoneControl,
IConfigCardAccess,
ISecurityTile {
    public InventoryCrafting dummyInv = MekanismUtils.getDummyCraftingInv();
    public double BASE_ENERGY_PER_TICK;
    public double energyPerTick;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired;
    public int operatingTicks;
    public boolean autoMode;
    public boolean isRecipe;
    public boolean stockControl;
    public boolean needsOrganize;
    public int pulseOperations;
    public RecipeFormula formula;
    public IRedstoneControl.RedstoneControl controlType;
    public TileComponentUpgrade upgradeComponent;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;
    public TileComponentSecurity securityComponent;
    public ItemStack lastFormulaStack;
    public boolean needsFormulaUpdate;
    public ItemStack lastOutputStack;

    public TileEntityFormulaicAssemblicator() {
        super("FormulaicAssemblicator", BlockStateMachine.MachineType.FORMULAIC_ASSEMBLICATOR.baseEnergy);
        this.energyPerTick = this.BASE_ENERGY_PER_TICK = MekanismConfig.current().usage.metallurgicInfuserUsage.val();
        this.ticksRequired = this.BASE_TICKS_REQUIRED = 40;
        this.autoMode = false;
        this.isRecipe = false;
        this.stockControl = false;
        this.needsOrganize = true;
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
        this.lastFormulaStack = ItemStack.field_190927_a;
        this.needsFormulaUpdate = false;
        this.lastOutputStack = ItemStack.field_190927_a;
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{21, 22, 23, 24, 25, 26}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{0, 0, 0, 3, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
        this.upgradeComponent = new TileComponentUpgrade(this, 0);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.securityComponent = new TileComponentSecurity(this);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.formula != null && this.stockControl && this.needsOrganize) {
                this.needsOrganize = false;
                this.organizeStock();
            }
            ChargeUtils.discharge(1, this);
            if (this.controlType != IRedstoneControl.RedstoneControl.PULSE) {
                this.pulseOperations = 0;
            } else if (MekanismUtils.canFunction(this)) {
                ++this.pulseOperations;
            }
            RecipeFormula prev = this.formula;
            if (!((ItemStack)this.inventory.get(2)).func_190926_b() && ((ItemStack)this.inventory.get(2)).func_77973_b() instanceof ItemCraftingFormula) {
                ItemCraftingFormula item = (ItemCraftingFormula)((ItemStack)this.inventory.get(2)).func_77973_b();
                if (this.formula == null || this.lastFormulaStack != this.inventory.get(2)) {
                    this.loadFormula();
                }
            } else {
                this.formula = null;
            }
            if (prev != this.formula) {
                this.needsFormulaUpdate = true;
            }
            this.lastFormulaStack = (ItemStack)this.inventory.get(2);
            if (this.autoMode && this.formula == null) {
                this.toggleAutoMode();
            }
            if (this.autoMode && this.formula != null && (this.controlType == IRedstoneControl.RedstoneControl.PULSE && this.pulseOperations > 0 || MekanismUtils.canFunction(this))) {
                boolean canOperate = true;
                if (!this.isRecipe) {
                    canOperate = this.moveItemsToGrid();
                }
                if (canOperate) {
                    this.isRecipe = true;
                    if (this.operatingTicks >= this.ticksRequired) {
                        if (this.doSingleCraft()) {
                            this.operatingTicks = 0;
                            if (this.pulseOperations > 0) {
                                --this.pulseOperations;
                            }
                            this.ejectorComponent.outputItems();
                        }
                    } else if (this.getEnergy() >= this.energyPerTick) {
                        ++this.operatingTicks;
                        this.setEnergy(this.getEnergy() - this.energyPerTick);
                    }
                } else {
                    this.operatingTicks = 0;
                }
            } else {
                this.operatingTicks = 0;
            }
        }
    }

    public void loadFormula() {
        ItemCraftingFormula item = (ItemCraftingFormula)((ItemStack)this.inventory.get(2)).func_77973_b();
        if (item.getInventory((ItemStack)this.inventory.get(2)) != null && !item.isInvalid((ItemStack)this.inventory.get(2))) {
            RecipeFormula itemFormula = new RecipeFormula(this.field_145850_b, item.getInventory((ItemStack)this.inventory.get(2)));
            if (itemFormula.isValidFormula(this.field_145850_b)) {
                if (this.formula != null && !this.formula.isFormulaEqual(this.field_145850_b, itemFormula)) {
                    this.formula = itemFormula;
                    this.operatingTicks = 0;
                } else if (this.formula == null) {
                    this.formula = itemFormula;
                }
            } else {
                this.formula = null;
                item.setInvalid((ItemStack)this.inventory.get(2), true);
            }
        } else {
            this.formula = null;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.formula == null) {
                for (int i = 0; i < 9; ++i) {
                    this.dummyInv.func_70299_a(i, (ItemStack)this.inventory.get(27 + i));
                }
                this.lastOutputStack = MekanismUtils.findMatchingRecipe(this.dummyInv, this.field_145850_b);
                this.isRecipe = !this.lastOutputStack.func_190926_b();
            } else {
                this.isRecipe = this.formula.matches(this.field_145850_b, (NonNullList<ItemStack>)this.inventory, 27);
                this.lastOutputStack = this.isRecipe ? this.formula.recipe.func_77571_b() : ItemStack.field_190927_a;
            }
            this.needsOrganize = true;
        }
    }

    private boolean doSingleCraft() {
        for (int i = 0; i < 9; ++i) {
            this.dummyInv.func_70299_a(i, (ItemStack)this.inventory.get(27 + i));
        }
        ItemStack output = this.lastOutputStack;
        if (!output.func_190926_b() && this.tryMoveToOutput(output, false)) {
            this.tryMoveToOutput(output, true);
            for (int i = 27; i <= 35; ++i) {
                if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                ItemStack stack = ((ItemStack)this.inventory.get(i)).func_77946_l();
                ((ItemStack)this.inventory.get(i)).func_190918_g(1);
                if (((ItemStack)this.inventory.get(i)).func_190916_E() != 0 || !stack.func_77973_b().hasContainerItem(stack)) continue;
                ItemStack container = stack.func_77973_b().getContainerItem(stack);
                if (!container.func_190926_b() && container.func_77984_f() && container.func_77952_i() > container.func_77958_k()) {
                    container = ItemStack.field_190927_a;
                }
                if (container.func_190926_b()) continue;
                boolean move = this.tryMoveToOutput(container.func_77946_l(), false);
                if (move) {
                    this.tryMoveToOutput(container.func_77946_l(), true);
                }
                this.inventory.set(i, (Object)(move ? ItemStack.field_190927_a : container.func_77946_l()));
            }
            if (this.formula != null) {
                this.moveItemsToGrid();
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    private boolean craftSingle() {
        if (this.formula != null) {
            boolean canOperate = true;
            if (!this.formula.matches(this.field_145850_b, (NonNullList<ItemStack>)this.inventory, 27)) {
                canOperate = this.moveItemsToGrid();
            }
            if (canOperate) {
                return this.doSingleCraft();
            }
        } else {
            return this.doSingleCraft();
        }
        return false;
    }

    private boolean moveItemsToGrid() {
        boolean ret = true;
        for (int i = 27; i <= 35; ++i) {
            if (this.formula.isIngredientInPos(this.field_145850_b, (ItemStack)this.inventory.get(i), i - 27)) continue;
            if (!((ItemStack)this.inventory.get(i)).func_190926_b()) {
                this.inventory.set(i, (Object)this.tryMoveToInput((ItemStack)this.inventory.get(i)));
                this.func_70296_d();
                if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                ret = false;
                continue;
            }
            boolean found = false;
            for (int j = 20; j >= 3; --j) {
                if (((ItemStack)this.inventory.get(j)).func_190926_b() || !this.formula.isIngredientInPos(this.field_145850_b, (ItemStack)this.inventory.get(j), i - 27)) continue;
                this.inventory.set(i, (Object)StackUtils.size((ItemStack)this.inventory.get(j), 1));
                ((ItemStack)this.inventory.get(j)).func_190918_g(1);
                this.func_70296_d();
                found = true;
                break;
            }
            if (found) continue;
            ret = false;
        }
        return ret;
    }

    private void craftAll() {
        while (this.craftSingle()) {
        }
    }

    private void moveItemsToInput(boolean forcePush) {
        for (int i = 27; i <= 35; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b() || !forcePush && (this.formula == null || this.formula.isIngredientInPos(this.field_145850_b, (ItemStack)this.inventory.get(i), i - 27))) continue;
            this.inventory.set(i, (Object)this.tryMoveToInput((ItemStack)this.inventory.get(i)));
        }
        this.func_70296_d();
    }

    private void toggleAutoMode() {
        if (this.autoMode) {
            this.operatingTicks = 0;
            this.autoMode = false;
        } else if (this.formula != null) {
            this.moveItemsToInput(false);
            this.autoMode = true;
        }
        this.func_70296_d();
    }

    private void toggleStockControl() {
        if (!this.field_145850_b.field_72995_K && this.formula != null) {
            boolean bl = this.stockControl = !this.stockControl;
            if (this.stockControl) {
                this.organizeStock();
            }
        }
    }

    private void organizeStock() {
        for (int j = 3; j <= 20; ++j) {
            for (int i = 20; i > j; --i) {
                if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                if (((ItemStack)this.inventory.get(j)).func_190926_b()) {
                    this.inventory.set(j, this.inventory.get(i));
                    this.inventory.set(i, (Object)ItemStack.field_190927_a);
                    this.func_70296_d();
                    return;
                }
                if (((ItemStack)this.inventory.get(j)).func_190916_E() >= ((ItemStack)this.inventory.get(j)).func_77976_d() || !InventoryUtils.areItemsStackable((ItemStack)this.inventory.get(i), (ItemStack)this.inventory.get(j))) continue;
                int newCount = ((ItemStack)this.inventory.get(j)).func_190916_E() + ((ItemStack)this.inventory.get(i)).func_190916_E();
                ((ItemStack)this.inventory.get(j)).func_190920_e(Math.min(((ItemStack)this.inventory.get(j)).func_77976_d(), newCount));
                ((ItemStack)this.inventory.get(i)).func_190920_e(Math.max(0, newCount - ((ItemStack)this.inventory.get(j)).func_77976_d()));
                this.func_70296_d();
                return;
            }
        }
    }

    private ItemStack tryMoveToInput(ItemStack stack) {
        stack = stack.func_77946_l();
        for (int i = 3; i <= 20; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) {
                this.inventory.set(i, (Object)stack);
                return ItemStack.field_190927_a;
            }
            if (!InventoryUtils.areItemsStackable(stack, (ItemStack)this.inventory.get(i)) || ((ItemStack)this.inventory.get(i)).func_190916_E() >= ((ItemStack)this.inventory.get(i)).func_77976_d()) continue;
            int toUse = Math.min(stack.func_190916_E(), ((ItemStack)this.inventory.get(i)).func_77976_d() - ((ItemStack)this.inventory.get(i)).func_190916_E());
            ((ItemStack)this.inventory.get(i)).func_190917_f(toUse);
            stack.func_190918_g(toUse);
            if (stack.func_190916_E() != 0) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    private boolean tryMoveToOutput(ItemStack stack, boolean doMove) {
        stack = stack.func_77946_l();
        for (int i = 21; i <= 26; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) {
                if (doMove) {
                    this.inventory.set(i, (Object)stack);
                }
                return true;
            }
            if (!InventoryUtils.areItemsStackable(stack, (ItemStack)this.inventory.get(i)) || ((ItemStack)this.inventory.get(i)).func_190916_E() >= ((ItemStack)this.inventory.get(i)).func_77976_d()) continue;
            int toUse = Math.min(stack.func_190916_E(), ((ItemStack)this.inventory.get(i)).func_77976_d() - ((ItemStack)this.inventory.get(i)).func_190916_E());
            if (doMove) {
                ((ItemStack)this.inventory.get(i)).func_190917_f(toUse);
            }
            stack.func_190918_g(toUse);
            if (stack.func_190916_E() != 0) continue;
            return true;
        }
        return false;
    }

    private void encodeFormula() {
        RecipeFormula formula;
        ItemCraftingFormula item;
        if (!((ItemStack)this.inventory.get(2)).func_190926_b() && ((ItemStack)this.inventory.get(2)).func_77973_b() instanceof ItemCraftingFormula && (item = (ItemCraftingFormula)((ItemStack)this.inventory.get(2)).func_77973_b()).getInventory((ItemStack)this.inventory.get(2)) == null && (formula = new RecipeFormula(this.field_145850_b, (NonNullList<ItemStack>)this.inventory, 27)).isValidFormula(this.field_145850_b)) {
            item.setInventory((ItemStack)this.inventory.get(2), formula.input);
            this.func_70296_d();
        }
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID >= 21 && slotID <= 26;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID >= 3 && slotID <= 20) {
            if (this.formula == null) {
                return true;
            }
            List<Integer> indices = this.formula.getIngredientIndices(this.field_145850_b, itemstack);
            if (indices.size() > 0) {
                if (this.stockControl) {
                    int filled = 0;
                    for (int i = 3; i < 20; ++i) {
                        if (((ItemStack)this.inventory.get(i)).func_190926_b() || !this.formula.isIngredientInPos(this.field_145850_b, (ItemStack)this.inventory.get(i), indices.get(0))) continue;
                        ++filled;
                    }
                    return filled < indices.size() * 2;
                }
                return true;
            }
        } else if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.autoMode = nbtTags.func_74767_n("autoMode");
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.pulseOperations = nbtTags.func_74762_e("pulseOperations");
        this.stockControl = nbtTags.func_74767_n("stockControl");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("autoMode", this.autoMode);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74768_a("pulseOperations", this.pulseOperations);
        nbtTags.func_74757_a("stockControl", this.stockControl);
        return nbtTags;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.toggleAutoMode();
            } else if (type == 1) {
                this.encodeFormula();
            } else if (type == 2) {
                this.craftSingle();
            } else if (type == 3) {
                this.craftAll();
            } else if (type == 4) {
                if (this.formula != null) {
                    this.moveItemsToGrid();
                } else {
                    this.moveItemsToInput(true);
                }
            } else if (type == 5) {
                this.toggleStockControl();
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.autoMode = dataStream.readBoolean();
            this.operatingTicks = dataStream.readInt();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.isRecipe = dataStream.readBoolean();
            this.stockControl = dataStream.readBoolean();
            if (dataStream.readBoolean()) {
                if (dataStream.readBoolean()) {
                    NonNullList inv = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
                    for (int i = 0; i < 9; ++i) {
                        if (!dataStream.readBoolean()) continue;
                        inv.set(i, (Object)PacketHandler.readStack(dataStream));
                    }
                    this.formula = new RecipeFormula(this.field_145850_b, (NonNullList<ItemStack>)inv);
                } else {
                    this.formula = null;
                }
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.autoMode);
        data.add(this.operatingTicks);
        data.add(this.controlType.ordinal());
        data.add(this.isRecipe);
        data.add(this.stockControl);
        if (this.needsFormulaUpdate) {
            data.add(true);
            if (this.formula != null) {
                data.add(true);
                for (int i = 0; i < 9; ++i) {
                    if (!((ItemStack)this.formula.input.get(i)).func_190926_b()) {
                        data.add(true);
                        data.add(this.formula.input.get(i));
                        continue;
                    }
                    data.add(false);
                }
            } else {
                data.add(false);
            }
        } else {
            data.add(false);
        }
        this.needsFormulaUpdate = false;
        return data;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                break;
            }
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.setEnergy(Math.min(this.getMaxEnergy(), this.getEnergy()));
                break;
            }
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.CONFIG_CARD_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.CONFIG_CARD_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }
}

