/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.TileNetworkList;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class TileEntityFluidicPlenisher
extends TileEntityElectricBlock
implements IComputerIntegration,
IConfigurable,
IFluidHandlerWrapper,
ISustainedTank,
IUpgradeTile,
IRedstoneControl,
ISecurityTile {
    private static final String[] methods = new String[]{"reset"};
    private static EnumSet<EnumFacing> dirs = EnumSet.complementOf(EnumSet.of(EnumFacing.UP));
    public Set<Coord4D> activeNodes = new LinkedHashSet<Coord4D>();
    public Set<Coord4D> usedNodes = new HashSet<Coord4D>();
    public boolean finishedCalc = false;
    public FluidTank fluidTank = new FluidTank(10000);
    public double BASE_ENERGY_PER_TICK;
    public double energyPerTick;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired;
    public int operatingTicks;
    public IRedstoneControl.RedstoneControl controlType;
    public TileComponentUpgrade upgradeComponent;
    public TileComponentSecurity securityComponent;

    public TileEntityFluidicPlenisher() {
        super("FluidicPlenisher", BlockStateMachine.MachineType.FLUIDIC_PLENISHER.baseEnergy);
        this.energyPerTick = this.BASE_ENERGY_PER_TICK = MekanismConfig.current().usage.fluidicPlenisherUsage.val();
        this.ticksRequired = this.BASE_TICKS_REQUIRED = 20;
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
        this.upgradeComponent = new TileComponentUpgrade(this, 3);
        this.securityComponent = new TileComponentSecurity(this);
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(2, this);
            if (FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(0))) {
                FluidContainerUtils.handleContainerItemEmpty(this, this.fluidTank, 0, 1, new FluidContainerUtils.FluidChecker(){

                    @Override
                    public boolean isValid(Fluid f) {
                        return f.canBePlacedInWorld();
                    }
                });
            }
            if (MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick && this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid().canBePlacedInWorld()) {
                if (!this.finishedCalc) {
                    this.setEnergy(this.getEnergy() - this.energyPerTick);
                }
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    if (!this.finishedCalc) {
                        this.doPlenish();
                    } else {
                        Coord4D below = Coord4D.get(this).offset(EnumFacing.DOWN);
                        if (this.canReplace(below, false, false) && this.fluidTank.getFluidAmount() >= 1000 && this.fluidTank.getFluid().getFluid().canBePlacedInWorld()) {
                            this.field_145850_b.func_180501_a(below.getPos(), MekanismUtils.getFlowingBlock(this.fluidTank.getFluid().getFluid()).func_176223_P(), 3);
                            this.setEnergy(this.getEnergy() - this.energyPerTick);
                            this.fluidTank.drain(1000, true);
                        }
                    }
                    this.operatingTicks = 0;
                }
            }
        }
    }

    private void doPlenish() {
        if (this.usedNodes.size() >= MekanismConfig.current().general.maxPlenisherNodes.val()) {
            this.finishedCalc = true;
            return;
        }
        if (this.activeNodes.isEmpty()) {
            if (this.usedNodes.isEmpty()) {
                Coord4D below = Coord4D.get(this).offset(EnumFacing.DOWN);
                if (!this.canReplace(below, true, true)) {
                    this.finishedCalc = true;
                    return;
                }
                this.activeNodes.add(below);
            } else {
                this.finishedCalc = true;
                return;
            }
        }
        HashSet<Coord4D> toRemove = new HashSet<Coord4D>();
        for (Coord4D coord : this.activeNodes) {
            if (coord.exists(this.field_145850_b)) {
                if (this.canReplace(coord, true, false)) {
                    this.field_145850_b.func_180501_a(coord.getPos(), MekanismUtils.getFlowingBlock(this.fluidTank.getFluid().getFluid()).func_176223_P(), 3);
                    this.fluidTank.drain(1000, true);
                }
                for (EnumFacing dir : dirs) {
                    Coord4D sideCoord = coord.offset(dir);
                    if (!sideCoord.exists(this.field_145850_b) || !this.canReplace(sideCoord, true, true)) continue;
                    this.activeNodes.add(sideCoord);
                }
                toRemove.add(coord);
                break;
            }
            toRemove.add(coord);
        }
        this.usedNodes.addAll(toRemove);
        this.activeNodes.removeAll(toRemove);
    }

    public boolean canReplace(Coord4D coord, boolean checkNodes, boolean isPathfinding) {
        if (checkNodes && this.usedNodes.contains(coord)) {
            return false;
        }
        if (coord.isAirBlock((IBlockAccess)this.field_145850_b) || MekanismUtils.isDeadFluid(this.field_145850_b, coord)) {
            return true;
        }
        if (MekanismUtils.isFluid(this.field_145850_b, coord)) {
            return isPathfinding;
        }
        return coord.getBlock((IBlockAccess)this.field_145850_b).func_176200_f((IBlockAccess)this.field_145850_b, coord.getPos());
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.finishedCalc = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            if (dataStream.readInt() == 1) {
                this.fluidTank.setFluid(new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)dataStream)), dataStream.readInt()));
            } else {
                this.fluidTank.setFluid(null);
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.finishedCalc);
        data.add(this.controlType.ordinal());
        if (this.fluidTank.getFluid() != null) {
            data.add(1);
            data.add(FluidRegistry.getFluidName((FluidStack)this.fluidTank.getFluid()));
            data.add(this.fluidTank.getFluid().amount);
        } else {
            data.add(0);
        }
        return data;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74757_a("finishedCalc", this.finishedCalc);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        NBTTagList activeList = new NBTTagList();
        for (Coord4D wrapper : this.activeNodes) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            wrapper.write(tagCompound);
            activeList.func_74742_a((NBTBase)tagCompound);
        }
        if (activeList.func_74745_c() != 0) {
            nbtTags.func_74782_a("activeNodes", (NBTBase)activeList);
        }
        NBTTagList usedList = new NBTTagList();
        for (Coord4D obj : this.usedNodes) {
            activeList.func_74742_a((NBTBase)obj.write(new NBTTagCompound()));
        }
        if (activeList.func_74745_c() != 0) {
            nbtTags.func_74782_a("usedNodes", (NBTBase)usedList);
        }
        return nbtTags;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        int i;
        NBTTagList tagList;
        super.func_145839_a(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.finishedCalc = nbtTags.func_74767_n("finishedCalc");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
        if (nbtTags.func_74764_b("activeNodes")) {
            tagList = nbtTags.func_150295_c("activeNodes", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                this.activeNodes.add(Coord4D.read(tagList.func_150305_b(i)));
            }
        }
        if (nbtTags.func_74764_b("usedNodes")) {
            tagList = nbtTags.func_150295_c("usedNodes", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                this.usedNodes.add(Coord4D.read(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 1) {
            return false;
        }
        if (slotID == 0) {
            return FluidUtil.getFluidContained((ItemStack)itemstack) != null && FluidUtil.getFluidContained((ItemStack)itemstack).getFluid().canBePlacedInWorld();
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 1;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return this.facing.func_176734_d() == side;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return new int[]{0};
        }
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        return new int[]{2};
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing direction) {
        if (direction == EnumFacing.UP) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(EnumFacing.UP);
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        return this.fluidTank.getFluid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == resource.getFluid() && from == EnumFacing.UP) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (from == EnumFacing.UP && resource.getFluid().canBePlacedInWorld()) {
            return this.fluidTank.fill(resource, true);
        }
        return 0;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, FluidStack fluid) {
        return from == EnumFacing.UP && fluid.getFluid().canBePlacedInWorld();
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return false;
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        this.activeNodes.clear();
        this.usedNodes.clear();
        this.finishedCalc = false;
        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurator.plenisherReset")));
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        return EnumActionResult.PASS;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.CONFIGURABLE_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper(this, side);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                this.activeNodes.clear();
                this.usedNodes.clear();
                this.finishedCalc = false;
                return new Object[]{"Plenisher calculation reset."};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
            }
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.setEnergy(Math.min(this.getMaxEnergy(), this.getEnergy()));
            }
        }
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

