/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class PressurizedInput
extends MachineInput<PressurizedInput> {
    private ItemStack theSolid = ItemStack.field_190927_a;
    private FluidStack theFluid;
    private GasStack theGas;

    public PressurizedInput(ItemStack solid, FluidStack fluid, GasStack gas) {
        this.theSolid = solid;
        this.theFluid = fluid;
        this.theGas = gas;
    }

    public PressurizedInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.theSolid = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("itemInput"));
        this.theFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("fluidInput"));
        this.theGas = GasStack.readFromNBT(nbtTags.func_74775_l("gasInput"));
    }

    @Override
    public boolean isValid() {
        return !this.theSolid.func_190926_b() && this.theFluid != null && this.theGas != null;
    }

    public boolean use(NonNullList<ItemStack> inventory, int index, FluidTank fluidTank, GasTank gasTank, boolean deplete) {
        if (this.meets(new PressurizedInput((ItemStack)inventory.get(index), fluidTank.getFluid(), gasTank.getGas()))) {
            if (deplete) {
                inventory.set(index, (Object)StackUtils.subtract((ItemStack)inventory.get(index), this.theSolid));
                fluidTank.drain(this.theFluid.amount, true);
                gasTank.draw(this.theGas.amount, true);
            }
            return true;
        }
        return false;
    }

    public boolean containsType(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return false;
        }
        return MachineInput.inputItemMatches(stack, this.theSolid);
    }

    public boolean containsType(FluidStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isFluidEqual(this.theFluid);
    }

    public boolean containsType(GasStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isGasEqual(this.theGas);
    }

    public boolean meets(PressurizedInput input) {
        if (input == null || !input.isValid()) {
            return false;
        }
        if (!(StackUtils.equalsWildcard(input.theSolid, this.theSolid) && input.theFluid.isFluidEqual(this.theFluid) && input.theGas.isGasEqual(this.theGas))) {
            return false;
        }
        return input.theSolid.func_190916_E() >= this.theSolid.func_190916_E() && input.theFluid.amount >= this.theFluid.amount && input.theGas.amount >= this.theGas.amount;
    }

    @Override
    public PressurizedInput copy() {
        return new PressurizedInput(this.theSolid.func_77946_l(), this.theFluid.copy(), this.theGas.copy());
    }

    public ItemStack getSolid() {
        return this.theSolid;
    }

    public FluidStack getFluid() {
        return this.theFluid;
    }

    public GasStack getGas() {
        return this.theGas;
    }

    @Override
    public int hashIngredients() {
        return StackUtils.hashItemStack(this.theSolid) << 16 | (this.theFluid.getFluid() != null ? this.theFluid.getFluid().hashCode() : 0) << 8 | this.theGas.hashCode();
    }

    @Override
    public boolean testEquality(PressurizedInput other) {
        return other.containsType(this.theSolid) && other.containsType(this.theFluid) && other.containsType(this.theGas);
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof PressurizedInput;
    }

    public PressurizedInput wildCopy() {
        return new PressurizedInput(new ItemStack(this.theSolid.func_77973_b(), this.theSolid.func_190916_E(), Short.MAX_VALUE), this.theFluid, this.theGas);
    }
}

