/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.tesla;

import mekanism.common.base.IEnergyWrapper;
import mekanism.common.config.MekanismConfig;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla")})
public class TeslaIntegration
implements ITeslaHolder,
ITeslaConsumer,
ITeslaProducer {
    public IEnergyWrapper tileEntity;
    public EnumFacing side;

    public TeslaIntegration(IEnergyWrapper tile, EnumFacing facing) {
        this.tileEntity = tile;
        this.side = facing;
    }

    @Optional.Method(modid="tesla")
    public long getStoredPower() {
        return Math.round(this.tileEntity.getEnergy() * MekanismConfig.current().general.TO_TESLA.val());
    }

    @Optional.Method(modid="tesla")
    public long getCapacity() {
        return Math.round(this.tileEntity.getMaxEnergy() * MekanismConfig.current().general.TO_TESLA.val());
    }

    @Optional.Method(modid="tesla")
    public long takePower(long power, boolean simulated) {
        return this.rfToTesla(this.tileEntity.extractEnergy(this.side, this.teslaToRF(power), simulated));
    }

    @Optional.Method(modid="tesla")
    public long givePower(long power, boolean simulated) {
        return this.rfToTesla(this.tileEntity.receiveEnergy(this.side, this.teslaToRF(power), simulated));
    }

    public long rfToTesla(int rf) {
        return Math.round((double)rf * MekanismConfig.current().general.FROM_RF.val() * MekanismConfig.current().general.TO_TESLA.val());
    }

    public int teslaToRF(long tesla) {
        return (int)Math.round(Math.min(2.147483647E9, (double)tesla * MekanismConfig.current().general.FROM_TESLA.val() * MekanismConfig.current().general.TO_RF.val()));
    }
}

