/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.common.config.BaseConfig;
import mekanism.common.config.Option;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

@ParametersAreNonnullByDefault
public class EnumOption<T extends Enum<T>>
extends Option<EnumOption<T>> {
    private final T defaultValue;
    private final Class<T> enumClass;
    private final T[] enumValues;
    private T value;

    EnumOption(BaseConfig owner, String category, String key, T defaultValue, @Nullable String comment) {
        super(owner, category, key, comment);
        this.defaultValue = (Enum)Objects.requireNonNull(defaultValue);
        this.value = defaultValue;
        this.enumClass = defaultValue.getClass();
        this.enumValues = (Enum[])this.enumClass.getEnumConstants();
    }

    EnumOption(BaseConfig owner, String category, String key, T defaultValue) {
        this(owner, category, key, defaultValue, null);
    }

    public T val() {
        return this.value;
    }

    public void set(T value) {
        this.value = (Enum)Objects.requireNonNull(value);
    }

    @Override
    protected void load(Configuration config) {
        Property prop = config.get(this.category, this.key, ((Enum)this.defaultValue).name(), this.comment);
        prop.setRequiresMcRestart(this.requiresGameRestart);
        prop.setRequiresWorldRestart(this.requiresWorldRestart);
        this.value = Enum.valueOf(this.enumClass, prop.getString());
    }

    @Override
    protected void write(ByteBuf buf) {
        buf.writeInt(((Enum)this.value).ordinal());
    }

    @Override
    protected void read(ByteBuf buf) {
        this.value = this.enumValues[buf.readInt()];
    }
}

