/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiChemicalCrystallizer;
import mekanism.client.gui.GuiChemicalDissolutionChamber;
import mekanism.client.gui.GuiChemicalInfuser;
import mekanism.client.gui.GuiChemicalInjectionChamber;
import mekanism.client.gui.GuiChemicalOxidizer;
import mekanism.client.gui.GuiChemicalWasher;
import mekanism.client.gui.GuiCombiner;
import mekanism.client.gui.GuiCrusher;
import mekanism.client.gui.GuiElectrolyticSeparator;
import mekanism.client.gui.GuiEnergizedSmelter;
import mekanism.client.gui.GuiEnrichmentChamber;
import mekanism.client.gui.GuiMetallurgicInfuser;
import mekanism.client.gui.GuiOsmiumCompressor;
import mekanism.client.gui.GuiPRC;
import mekanism.client.gui.GuiPrecisionSawmill;
import mekanism.client.gui.GuiPurificationChamber;
import mekanism.client.gui.GuiRotaryCondensentrator;
import mekanism.client.gui.GuiSolarNeutronActivator;
import mekanism.client.gui.GuiThermalEvaporationController;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.jei.GasStackHelper;
import mekanism.client.jei.GuiElementHandler;
import mekanism.client.jei.gas.GasStackRenderer;
import mekanism.client.jei.machine.AdvancedMachineRecipeCategory;
import mekanism.client.jei.machine.ChanceMachineRecipeCategory;
import mekanism.client.jei.machine.DoubleMachineRecipeCategory;
import mekanism.client.jei.machine.MachineRecipeCategory;
import mekanism.client.jei.machine.advanced.ChemicalInjectionChamberRecipeWrapper;
import mekanism.client.jei.machine.advanced.CombinerRecipeWrapper;
import mekanism.client.jei.machine.advanced.OsmiumCompressorRecipeWrapper;
import mekanism.client.jei.machine.advanced.PurificationChamberRecipeWrapper;
import mekanism.client.jei.machine.basic.CrusherRecipeWrapper;
import mekanism.client.jei.machine.basic.EnrichmentRecipeWrapper;
import mekanism.client.jei.machine.basic.SmeltingRecipeWrapper;
import mekanism.client.jei.machine.chance.PrecisionSawmillRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalCrystallizerRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalCrystallizerRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalDissolutionChamberRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalDissolutionChamberRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalInfuserRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalInfuserRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalOxidizerRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalOxidizerRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalWasherRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalWasherRecipeWrapper;
import mekanism.client.jei.machine.other.ElectrolyticSeparatorRecipeCategory;
import mekanism.client.jei.machine.other.ElectrolyticSeparatorRecipeWrapper;
import mekanism.client.jei.machine.other.MetallurgicInfuserRecipeCategory;
import mekanism.client.jei.machine.other.MetallurgicInfuserRecipeWrapper;
import mekanism.client.jei.machine.other.PRCRecipeCategory;
import mekanism.client.jei.machine.other.PRCRecipeWrapper;
import mekanism.client.jei.machine.other.RotaryCondensentratorRecipeCategory;
import mekanism.client.jei.machine.other.RotaryCondensentratorRecipeWrapper;
import mekanism.client.jei.machine.other.SolarNeutronRecipeCategory;
import mekanism.client.jei.machine.other.SolarNeutronRecipeWrapper;
import mekanism.client.jei.machine.other.ThermalEvaporationRecipeCategory;
import mekanism.client.jei.machine.other.ThermalEvaporationRecipeWrapper;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.Tier;
import mekanism.common.base.IFactory;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.integration.crafttweaker.handlers.EnergizedSmelter;
import mekanism.common.inventory.container.ContainerFormulaicAssemblicator;
import mekanism.common.inventory.container.ContainerRobitInventory;
import mekanism.common.item.ItemBlockEnergyCube;
import mekanism.common.item.ItemBlockGasTank;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.machines.CombinerRecipe;
import mekanism.common.recipe.machines.CrusherRecipe;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.machines.DoubleMachineRecipe;
import mekanism.common.recipe.machines.EnrichmentRecipe;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.machines.OsmiumCompressorRecipe;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.machines.PurificationRecipe;
import mekanism.common.recipe.machines.SawmillRecipe;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.machines.SmeltingRecipe;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.machines.ThermalEvaporationRecipe;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.util.MekanismUtils;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.tuple.Pair;

@JEIPlugin
public class MekanismJEI
implements IModPlugin {
    public static final IIngredientType<GasStack> GAS_INGREDIENT_TYPE = () -> GasStack.class;
    public static final ISubtypeRegistry.ISubtypeInterpreter NBT_INTERPRETER = itemStack -> {
        GasStack gasStack;
        String ret = Integer.toString(itemStack.func_77960_j());
        if (itemStack.func_77973_b() instanceof ITierItem) {
            ret = ret + ":" + ((ITierItem)itemStack.func_77973_b()).getBaseTier(itemStack).getSimpleName();
        }
        if (itemStack.func_77973_b() instanceof IFactory) {
            ret = ret + ":" + IFactory.RecipeType.values()[((IFactory)itemStack.func_77973_b()).getRecipeType(itemStack)].func_176610_l();
        }
        if (itemStack.func_77973_b() instanceof ItemBlockGasTank && (gasStack = ((ItemBlockGasTank)itemStack.func_77973_b()).getGas(itemStack)) != null) {
            ret = ret + ":" + gasStack.getGas().getName();
        }
        if (itemStack.func_77973_b() instanceof ItemBlockEnergyCube) {
            ret = ret + ":" + (((ItemBlockEnergyCube)itemStack.func_77973_b()).getEnergy(itemStack) > 0.0 ? "filled" : "empty");
        }
        return ret.isEmpty() ? "" : ret.toLowerCase(Locale.ROOT);
    };
    private static final GasStackRenderer GAS_RENDERER = new GasStackRenderer();
    private static final boolean CRAFTTWEAKER_LOADED = Loader.isModLoaded((String)"crafttweaker");

    public void registerItemSubtypes(ISubtypeRegistry registry) {
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.EnergyCube), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock2), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock3), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.BasicBlock), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.BasicBlock2), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.GasTank), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.CardboardBox), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.Transmitter), NBT_INTERPRETER);
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        List list = GasRegistry.getRegisteredGasses().stream().filter(Gas::isVisible).map(g -> new GasStack((Gas)g, 1000)).collect(Collectors.toList());
        registry.register(GAS_INGREDIENT_TYPE, list, (IIngredientHelper)new GasStackHelper(), (IIngredientRenderer)GAS_RENDERER);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        ArrayList<Pair> categories = new ArrayList<Pair>();
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER, () -> new ChemicalCrystallizerRecipeCategory(guiHelper)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER, () -> new ChemicalDissolutionChamberRecipeCategory(guiHelper)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.CHEMICAL_INFUSER, () -> new ChemicalInfuserRecipeCategory(guiHelper)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.CHEMICAL_OXIDIZER, () -> new ChemicalOxidizerRecipeCategory(guiHelper)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.CHEMICAL_WASHER, () -> new ChemicalWasherRecipeCategory(guiHelper)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR, () -> new ElectrolyticSeparatorRecipeCategory(guiHelper)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.METALLURGIC_INFUSER, () -> new MetallurgicInfuserRecipeCategory(guiHelper)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER, () -> new PRCRecipeCategory(guiHelper)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR, () -> new RotaryCondensentratorRecipeCategory(guiHelper, true)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR, () -> new RotaryCondensentratorRecipeCategory(guiHelper, false)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR, () -> new SolarNeutronRecipeCategory(guiHelper)));
        categories.add(Pair.of(null, () -> new ThermalEvaporationRecipeCategory(guiHelper)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.COMBINER, () -> new DoubleMachineRecipeCategory(guiHelper, RecipeHandler.Recipe.COMBINER.jeiRecipeUid, "tile.MachineBlock.Combiner.name", GuiProgress.ProgressBar.STONE)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.PURIFICATION_CHAMBER, () -> new AdvancedMachineRecipeCategory(guiHelper, RecipeHandler.Recipe.PURIFICATION_CHAMBER.jeiRecipeUid, "tile.MachineBlock.PurificationChamber.name", GuiProgress.ProgressBar.RED)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.OSMIUM_COMPRESSOR, () -> new AdvancedMachineRecipeCategory(guiHelper, RecipeHandler.Recipe.OSMIUM_COMPRESSOR.jeiRecipeUid, "tile.MachineBlock.OsmiumCompressor.name", GuiProgress.ProgressBar.RED)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER, () -> new AdvancedMachineRecipeCategory(guiHelper, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.jeiRecipeUid, "nei.chemicalInjectionChamber", GuiProgress.ProgressBar.YELLOW)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.PRECISION_SAWMILL, () -> new ChanceMachineRecipeCategory(guiHelper, RecipeHandler.Recipe.PRECISION_SAWMILL.jeiRecipeUid, "tile.MachineBlock2.PrecisionSawmill.name", GuiProgress.ProgressBar.PURPLE)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.ENRICHMENT_CHAMBER, () -> new MachineRecipeCategory(guiHelper, RecipeHandler.Recipe.ENRICHMENT_CHAMBER.jeiRecipeUid, "tile.MachineBlock.EnrichmentChamber.name", GuiProgress.ProgressBar.BLUE)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.CRUSHER, () -> new MachineRecipeCategory(guiHelper, RecipeHandler.Recipe.CRUSHER.jeiRecipeUid, "tile.MachineBlock.Crusher.name", GuiProgress.ProgressBar.CRUSH)));
        categories.add(Pair.of((Object)BlockStateMachine.MachineType.ENERGIZED_SMELTER, () -> new MachineRecipeCategory(guiHelper, RecipeHandler.Recipe.ENERGIZED_SMELTER.jeiRecipeUid, "tile.MachineBlock.EnergizedSmelter.name", GuiProgress.ProgressBar.BLUE)));
        registry.addRecipeCategories((IRecipeCategory[])categories.stream().filter(p -> p.getLeft() == null || ((BlockStateMachine.MachineType)p.getLeft()).isEnabled()).map(it -> (IRecipeCategory)((Supplier)it.getRight()).get()).toArray(IRecipeCategory[]::new));
    }

    public void register(IModRegistry registry) {
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new GuiElementHandler()});
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(MekanismItems.ItemProxy));
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(MekanismBlocks.BoundingBlock));
        if (BlockStateMachine.MachineType.ENRICHMENT_CHAMBER.isEnabled()) {
            registry.handleRecipes(EnrichmentRecipe.class, EnrichmentRecipeWrapper::new, RecipeHandler.Recipe.ENRICHMENT_CHAMBER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.ENRICHMENT_CHAMBER, BasicMachineRecipe.class, EnrichmentRecipeWrapper.class, RecipeHandler.Recipe.ENRICHMENT_CHAMBER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiEnrichmentChamber.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.ENRICHMENT_CHAMBER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.CRUSHER.isEnabled()) {
            registry.handleRecipes(CrusherRecipe.class, CrusherRecipeWrapper::new, RecipeHandler.Recipe.CRUSHER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.CRUSHER, BasicMachineRecipe.class, CrusherRecipeWrapper.class, RecipeHandler.Recipe.CRUSHER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiCrusher.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.CRUSHER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.COMBINER.isEnabled()) {
            registry.handleRecipes(CombinerRecipe.class, CombinerRecipeWrapper::new, RecipeHandler.Recipe.COMBINER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.COMBINER, DoubleMachineRecipe.class, CombinerRecipeWrapper.class, RecipeHandler.Recipe.COMBINER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiCombiner.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.COMBINER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.PURIFICATION_CHAMBER.isEnabled()) {
            registry.handleRecipes(PurificationRecipe.class, PurificationChamberRecipeWrapper::new, RecipeHandler.Recipe.PURIFICATION_CHAMBER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.PURIFICATION_CHAMBER, AdvancedMachineRecipe.class, PurificationChamberRecipeWrapper.class, RecipeHandler.Recipe.PURIFICATION_CHAMBER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiPurificationChamber.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.PURIFICATION_CHAMBER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.OSMIUM_COMPRESSOR.isEnabled()) {
            registry.handleRecipes(OsmiumCompressorRecipe.class, OsmiumCompressorRecipeWrapper::new, RecipeHandler.Recipe.OSMIUM_COMPRESSOR.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.OSMIUM_COMPRESSOR, AdvancedMachineRecipe.class, OsmiumCompressorRecipeWrapper.class, RecipeHandler.Recipe.OSMIUM_COMPRESSOR.jeiRecipeUid);
            registry.addRecipeClickArea(GuiOsmiumCompressor.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.OSMIUM_COMPRESSOR.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER.isEnabled()) {
            registry.handleRecipes(InjectionRecipe.class, ChemicalInjectionChamberRecipeWrapper::new, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER, AdvancedMachineRecipe.class, ChemicalInjectionChamberRecipeWrapper.class, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiChemicalInjectionChamber.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.PRECISION_SAWMILL.isEnabled()) {
            registry.handleRecipes(SawmillRecipe.class, PrecisionSawmillRecipeWrapper::new, RecipeHandler.Recipe.PRECISION_SAWMILL.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.PRECISION_SAWMILL, ChanceMachineRecipe.class, PrecisionSawmillRecipeWrapper.class, RecipeHandler.Recipe.PRECISION_SAWMILL.jeiRecipeUid);
            registry.addRecipeClickArea(GuiPrecisionSawmill.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.PRECISION_SAWMILL.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.METALLURGIC_INFUSER.isEnabled()) {
            registry.handleRecipes(MetallurgicInfuserRecipe.class, MetallurgicInfuserRecipeWrapper::new, RecipeHandler.Recipe.METALLURGIC_INFUSER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.METALLURGIC_INFUSER, MetallurgicInfuserRecipe.class, MetallurgicInfuserRecipeWrapper.class, RecipeHandler.Recipe.METALLURGIC_INFUSER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiMetallurgicInfuser.class, 72, 47, 32, 8, new String[]{RecipeHandler.Recipe.METALLURGIC_INFUSER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER.isEnabled()) {
            registry.handleRecipes(CrystallizerRecipe.class, ChemicalCrystallizerRecipeWrapper::new, RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER, CrystallizerRecipe.class, ChemicalCrystallizerRecipeWrapper.class, RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiChemicalCrystallizer.class, 53, 62, 48, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER.isEnabled()) {
            registry.handleRecipes(DissolutionRecipe.class, ChemicalDissolutionChamberRecipeWrapper::new, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER, DissolutionRecipe.class, ChemicalDissolutionChamberRecipeWrapper.class, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiChemicalDissolutionChamber.class, 64, 40, 48, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.CHEMICAL_INFUSER.isEnabled()) {
            registry.handleRecipes(ChemicalInfuserRecipe.class, ChemicalInfuserRecipeWrapper::new, RecipeHandler.Recipe.CHEMICAL_INFUSER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_INFUSER, ChemicalInfuserRecipe.class, ChemicalInfuserRecipeWrapper.class, RecipeHandler.Recipe.CHEMICAL_INFUSER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiChemicalInfuser.class, 47, 39, 28, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_INFUSER.jeiRecipeUid});
            registry.addRecipeClickArea(GuiChemicalInfuser.class, 101, 39, 28, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_INFUSER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.CHEMICAL_OXIDIZER.isEnabled()) {
            registry.handleRecipes(OxidationRecipe.class, ChemicalOxidizerRecipeWrapper::new, RecipeHandler.Recipe.CHEMICAL_OXIDIZER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_OXIDIZER, OxidationRecipe.class, ChemicalOxidizerRecipeWrapper.class, RecipeHandler.Recipe.CHEMICAL_OXIDIZER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiChemicalOxidizer.class, 64, 40, 48, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_OXIDIZER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.CHEMICAL_WASHER.isEnabled()) {
            registry.handleRecipes(WasherRecipe.class, ChemicalWasherRecipeWrapper::new, RecipeHandler.Recipe.CHEMICAL_WASHER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_WASHER, WasherRecipe.class, ChemicalWasherRecipeWrapper.class, RecipeHandler.Recipe.CHEMICAL_WASHER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiChemicalWasher.class, 61, 39, 55, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_WASHER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR.isEnabled()) {
            registry.handleRecipes(SolarNeutronRecipe.class, SolarNeutronRecipeWrapper::new, RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR, SolarNeutronRecipe.class, SolarNeutronRecipeWrapper.class, RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.jeiRecipeUid);
            registry.addRecipeClickArea(GuiSolarNeutronActivator.class, 64, 39, 48, 8, new String[]{RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR.isEnabled()) {
            registry.handleRecipes(SeparatorRecipe.class, ElectrolyticSeparatorRecipeWrapper::new, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR, SeparatorRecipe.class, ElectrolyticSeparatorRecipeWrapper.class, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.jeiRecipeUid);
            registry.addRecipeClickArea(GuiElectrolyticSeparator.class, 80, 30, 16, 6, new String[]{RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.jeiRecipeUid});
        }
        registry.handleRecipes(ThermalEvaporationRecipe.class, ThermalEvaporationRecipeWrapper::new, RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.jeiRecipeUid);
        this.addRecipes(registry, RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT, ThermalEvaporationRecipe.class, ThermalEvaporationRecipeWrapper.class, RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.jeiRecipeUid);
        registry.addRecipeClickArea(GuiThermalEvaporationController.class, 49, 20, 78, 38, new String[]{RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.jeiRecipeUid});
        if (BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER.isEnabled()) {
            registry.handleRecipes(PressurizedRecipe.class, PRCRecipeWrapper::new, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.jeiRecipeUid);
            this.addRecipes(registry, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER, PressurizedRecipe.class, PRCRecipeWrapper.class, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.jeiRecipeUid);
            registry.addRecipeClickArea(GuiPRC.class, 75, 37, 36, 10, new String[]{RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.jeiRecipeUid});
        }
        if (BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR.isEnabled()) {
            ArrayList<RotaryCondensentratorRecipeWrapper> condensentratorRecipes = new ArrayList<RotaryCondensentratorRecipeWrapper>();
            ArrayList<RotaryCondensentratorRecipeWrapper> decondensentratorRecipes = new ArrayList<RotaryCondensentratorRecipeWrapper>();
            for (Gas gas : GasRegistry.getRegisteredGasses()) {
                if (!gas.hasFluid()) continue;
                condensentratorRecipes.add(new RotaryCondensentratorRecipeWrapper(gas.getFluid(), gas, true));
                decondensentratorRecipes.add(new RotaryCondensentratorRecipeWrapper(gas.getFluid(), gas, false));
            }
            registry.addRecipes(condensentratorRecipes, "mekanism.rotary_condensentrator_condensentrating");
            registry.addRecipes(decondensentratorRecipes, "mekanism.rotary_condensentrator_decondensentrating");
            registry.addRecipeClickArea(GuiRotaryCondensentrator.class, 64, 39, 48, 8, new String[]{"mekanism.rotary_condensentrator_condensentrating", "mekanism.rotary_condensentrator_decondensentrating"});
        }
        if (BlockStateMachine.MachineType.ENERGIZED_SMELTER.isEnabled()) {
            registry.handleRecipes(SmeltingRecipe.class, SmeltingRecipeWrapper::new, RecipeHandler.Recipe.ENERGIZED_SMELTER.jeiRecipeUid);
            if (CRAFTTWEAKER_LOADED && EnergizedSmelter.hasRemovedRecipe()) {
                this.addRecipes(registry, RecipeHandler.Recipe.ENERGIZED_SMELTER, BasicMachineRecipe.class, SmeltingRecipeWrapper.class, RecipeHandler.Recipe.ENERGIZED_SMELTER.jeiRecipeUid);
            } else if (CRAFTTWEAKER_LOADED && EnergizedSmelter.hasAddedRecipe()) {
                Map<ItemStackInput, SmeltingRecipe> smeltingRecipes = RecipeHandler.Recipe.ENERGIZED_SMELTER.get();
                Collection<SmeltingRecipe> recipes = smeltingRecipes.entrySet().stream().filter(entry -> !FurnaceRecipes.func_77602_a().func_77599_b().keySet().contains(((ItemStackInput)entry.getKey()).ingredient)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).values();
                this.addRecipes(registry, recipes, BasicMachineRecipe.class, SmeltingRecipeWrapper.class, RecipeHandler.Recipe.ENERGIZED_SMELTER.jeiRecipeUid);
            }
        }
        if (BlockStateMachine.MachineType.ENERGIZED_SMELTER.isEnabled()) {
            if (CRAFTTWEAKER_LOADED && EnergizedSmelter.hasRemovedRecipe()) {
                registry.addRecipeClickArea(GuiEnergizedSmelter.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.ENERGIZED_SMELTER.jeiRecipeUid});
            } else if (CRAFTTWEAKER_LOADED && EnergizedSmelter.hasAddedRecipe()) {
                registry.addRecipeClickArea(GuiEnergizedSmelter.class, 79, 40, 24, 7, new String[]{"minecraft.smelting", RecipeHandler.Recipe.ENERGIZED_SMELTER.jeiRecipeUid});
                this.registerVanillaSmeltingRecipeCatalyst(registry);
            } else {
                registry.addRecipeClickArea(GuiEnergizedSmelter.class, 79, 40, 24, 7, new String[]{"minecraft.smelting"});
                this.registerVanillaSmeltingRecipeCatalyst(registry);
            }
        }
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.ENRICHMENT_CHAMBER, RecipeHandler.Recipe.ENRICHMENT_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CRUSHER, RecipeHandler.Recipe.CRUSHER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.ENERGIZED_SMELTER, RecipeHandler.Recipe.ENERGIZED_SMELTER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.COMBINER, RecipeHandler.Recipe.COMBINER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.PURIFICATION_CHAMBER, RecipeHandler.Recipe.PURIFICATION_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.OSMIUM_COMPRESSOR, RecipeHandler.Recipe.OSMIUM_COMPRESSOR);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.PRECISION_SAWMILL, RecipeHandler.Recipe.PRECISION_SAWMILL);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.METALLURGIC_INFUSER, RecipeHandler.Recipe.METALLURGIC_INFUSER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER, RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_INFUSER, RecipeHandler.Recipe.CHEMICAL_INFUSER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_OXIDIZER, RecipeHandler.Recipe.CHEMICAL_OXIDIZER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_WASHER, RecipeHandler.Recipe.CHEMICAL_WASHER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR, RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER);
        registry.addRecipeCatalyst((Object)BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR.getStack(), new String[]{"mekanism.rotary_condensentrator_condensentrating", "mekanism.rotary_condensentrator_decondensentrating"});
        registry.addRecipeCatalyst((Object)BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_CONTROLLER.getStack(1), new String[]{RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.jeiRecipeUid});
        registry.addRecipeCatalyst((Object)BlockStateMachine.MachineType.FORMULAIC_ASSEMBLICATOR.getStack(), new String[]{"minecraft.crafting"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerFormulaicAssemblicator.class, "minecraft.crafting", 20, 9, 35, 36);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerRobitInventory.class, "minecraft.crafting", 1, 9, 10, 36);
    }

    private void registerRecipeItem(IModRegistry registry, BlockStateMachine.MachineType type, RecipeHandler.Recipe<?, ?, ?> recipeType) {
        if (!type.isEnabled()) {
            return;
        }
        registry.addRecipeCatalyst((Object)type.getStack(), new String[]{recipeType.jeiRecipeUid});
        IFactory.RecipeType factoryType = null;
        for (IFactory.RecipeType recipeType2 : IFactory.RecipeType.values()) {
            if (recipeType2.getType() != type) continue;
            factoryType = recipeType2;
            break;
        }
        if (factoryType != null) {
            for (Enum enum_ : Tier.FactoryTier.values()) {
                if (!((Tier.FactoryTier)enum_).machineType.isEnabled()) continue;
                registry.addRecipeCatalyst((Object)MekanismUtils.getFactory((Tier.FactoryTier)enum_, factoryType), new String[]{recipeType.jeiRecipeUid});
            }
        }
    }

    private void addRecipes(IModRegistry registry, RecipeHandler.Recipe type, Class<?> recipe, Class<? extends IRecipeWrapper> wrapper, String recipeCategoryUid) {
        this.addRecipes(registry, type.get().values(), recipe, wrapper, recipeCategoryUid);
    }

    private void addRecipes(IModRegistry registry, Collection recipeList, Class<?> recipe, Class<? extends IRecipeWrapper> wrapper, String recipeCategoryUid) {
        ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
        for (Object obj : recipeList) {
            if (!(obj instanceof MachineRecipe)) continue;
            try {
                recipes.add(wrapper.getConstructor(recipe).newInstance(obj));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Mekanism.logger.fatal("Error registering JEI recipe: " + recipe.getName(), (Throwable)e);
            }
        }
        registry.addRecipes(recipes, recipeCategoryUid);
    }

    private void registerVanillaSmeltingRecipeCatalyst(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)BlockStateMachine.MachineType.ENERGIZED_SMELTER.getStack(), new String[]{"minecraft.smelting"});
        for (Tier.FactoryTier tier : Tier.FactoryTier.values()) {
            if (!tier.machineType.isEnabled()) continue;
            registry.addRecipeCatalyst((Object)MekanismUtils.getFactory(tier, IFactory.RecipeType.SMELTING), new String[]{"minecraft.smelting"});
        }
    }
}

