/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities;

import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesLoadedChunkManager;
import com.feed_the_beast.ftbutilities.data.Leaderboard;
import com.feed_the_beast.ftbutilities.data.NodeEntry;
import com.feed_the_beast.ftbutilities.events.CustomPermissionPrefixesRegistryEvent;
import com.feed_the_beast.ftbutilities.events.LeaderboardRegistryEvent;
import com.feed_the_beast.ftbutilities.net.FTBUtilitiesNetHandler;
import com.feed_the_beast.ftbutilities.ranks.FTBUtilitiesPermissionHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;

public class FTBUtilitiesCommon {
    public static final Collection<NodeEntry> CUSTOM_PERM_PREFIX_REGISTRY = new HashSet<NodeEntry>();
    public static final Map<ResourceLocation, Leaderboard> LEADERBOARDS = new HashMap<ResourceLocation, Leaderboard>();

    public void preInit() {
        FTBUtilitiesConfig.sync();
        if (FTBUtilitiesConfig.ranks.enabled) {
            PermissionAPI.setPermissionHandler((IPermissionHandler)FTBUtilitiesPermissionHandler.INSTANCE);
        }
        FTBUtilitiesNetHandler.init();
        if (!ForgeChunkManager.getConfig().hasCategory("ftbutilities")) {
            ForgeChunkManager.getConfig().get("ftbutilities", "maximumChunksPerTicket", 1000000).setMinValue(0);
            ForgeChunkManager.getConfig().get("ftbutilities", "maximumTicketCount", 1000000).setMinValue(0);
            ForgeChunkManager.getConfig().save();
        }
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)FTBUtilities.INST, (ForgeChunkManager.LoadingCallback)FTBUtilitiesLoadedChunkManager.INSTANCE);
        new CustomPermissionPrefixesRegistryEvent(CUSTOM_PERM_PREFIX_REGISTRY::add).post();
    }

    public void init() {
        new LeaderboardRegistryEvent(leaderboard -> LEADERBOARDS.put(leaderboard.id, (Leaderboard)leaderboard)).post();
        FTBUtilitiesPermissions.registerPermissions();
    }

    public void postInit() {
    }

    public void imc(FMLInterModComms.IMCMessage message) {
    }
}

