/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.structure.array;

import hellfirepvp.astralsorcery.common.structure.MatchableStructure;
import hellfirepvp.astralsorcery.common.structure.array.BlockArray;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PatternBlockArray
extends BlockArray
implements MatchableStructure {
    private final ResourceLocation registryName;

    public PatternBlockArray(ResourceLocation name) {
        this.registryName = name;
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public boolean matches(World world, BlockPos center) {
        for (Map.Entry entry : this.pattern.entrySet()) {
            BlockArray.BlockInformation info = (BlockArray.BlockInformation)entry.getValue();
            BlockPos at = center.func_177971_a((Vec3i)entry.getKey());
            IBlockState state = world.func_180495_p(at);
            if (info.matcher.isStateValid(state)) continue;
            return false;
        }
        return true;
    }

    public boolean matchSingleBlockState(BlockPos offset, IBlockState state) {
        if (!this.pattern.containsKey(offset)) {
            return false;
        }
        BlockArray.BlockInformation info = (BlockArray.BlockInformation)this.pattern.get(offset);
        return info.matcher.isStateValid(state);
    }

    public boolean matchSingleBlock(IBlockAccess world, BlockPos center, BlockPos offset) {
        if (!this.pattern.containsKey(offset)) {
            return false;
        }
        BlockArray.BlockInformation info = (BlockArray.BlockInformation)this.pattern.get(offset);
        BlockPos at = center.func_177971_a((Vec3i)offset);
        IBlockState state = world.func_180495_p(at);
        return info.matcher.isStateValid(state);
    }
}

