/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.base.LightOreTransmutations;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.base.WellLiquefaction;
import hellfirepvp.astralsorcery.common.block.BlockMachine;
import hellfirepvp.astralsorcery.common.block.network.BlockAltar;
import hellfirepvp.astralsorcery.common.container.ContainerAltarAttunement;
import hellfirepvp.astralsorcery.common.container.ContainerAltarConstellation;
import hellfirepvp.astralsorcery.common.container.ContainerAltarDiscovery;
import hellfirepvp.astralsorcery.common.container.ContainerAltarTrait;
import hellfirepvp.astralsorcery.common.crafting.altar.AltarRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.DiscoveryRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.grindstone.GrindstoneRecipe;
import hellfirepvp.astralsorcery.common.crafting.grindstone.GrindstoneRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipeAdapater;
import hellfirepvp.astralsorcery.common.crafting.infusion.AbstractInfusionRecipe;
import hellfirepvp.astralsorcery.common.crafting.infusion.InfusionRecipeRegistry;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationGeolosys;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.CategoryGrindstone;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.CategoryInfuser;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.CategoryTransmutation;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.CategoryWell;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.GrindstoneRecipeWrapper;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.InfuserRecipeWrapper;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.TransmutationRecipeWrapper;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.WellRecipeWrapper;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.altar.AltarAttunementRecipeWrapper;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.altar.AltarConstellationRecipeWrapper;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.altar.AltarDiscoveryRecipeWrapper;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.altar.AltarTraitRecipeWrapper;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.altar.CategoryAltarAttunement;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.altar.CategoryAltarConstellation;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.altar.CategoryAltarDiscovery;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.altar.CategoryAltarTrait;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.util.JEISessionHandler;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.util.TieredAltarRecipeTransferHandler;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.RecipesAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.startup.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

@JEIPlugin
public class ModIntegrationJEI
implements IModPlugin {
    private static Map<Class<?>, Tuple<IRecipeWrapperFactory, String>> factoryMap = new HashMap();
    private static List<RecipeChange> recipePrimer = new LinkedList<RecipeChange>();
    private static List<Tuple<Object, ModificationAction>> unresolvedRecipes = new LinkedList<Tuple<Object, ModificationAction>>();
    public static boolean jeiRegistrationPhase = true;
    public static final String idWell = "astralsorcery.lightwell";
    public static final String idGrindstone = "astralsorcery.grindstone";
    public static final String idInfuser = "astralsorcery.infuser";
    public static final String idTransmutation = "astralsorcery.lightTransmutation";
    public static final String idAltarDiscovery = "astralsorcery.altar.discovery";
    public static final String idAltarAttunement = "astralsorcery.altar.attunement";
    public static final String idAltarConstellation = "astralsorcery.altar.constellation";
    public static final String idAltarTrait = "astralsorcery.altar.trait";
    public static IStackHelper stackHelper;
    public static IJeiHelpers jeiHelpers;
    public static IRecipeRegistry recipeRegistry;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.useNbtForSubtypes(new Item[]{ItemsAS.wand, ItemsAS.armorImbuedCape, ItemsAS.shiftingStar});
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CategoryWell(guiHelper), new CategoryGrindstone(guiHelper), new CategoryInfuser(guiHelper), new CategoryTransmutation(guiHelper), new CategoryAltarTrait(guiHelper), new CategoryAltarConstellation(guiHelper), new CategoryAltarAttunement(guiHelper), new CategoryAltarDiscovery(guiHelper)});
    }

    public void register(IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        stackHelper = jeiHelpers.getStackHelper();
        MinecraftForge.EVENT_BUS.register((Object)JEISessionHandler.getInstance());
        this.hideItems(registry.getJeiHelpers().getIngredientBlacklist());
        IRecipeTransferRegistry rtr = registry.getRecipeTransferRegistry();
        this.registerRecipeHandle(registry, WellLiquefaction.LiquefactionEntry.class, WellRecipeWrapper::new, idWell);
        this.registerRecipeHandle(registry, GrindstoneRecipe.class, GrindstoneRecipeWrapper::new, idGrindstone);
        this.registerRecipeHandle(registry, AbstractInfusionRecipe.class, InfuserRecipeWrapper::new, idInfuser);
        this.registerRecipeHandle(registry, LightOreTransmutations.Transmutation.class, TransmutationRecipeWrapper::new, idTransmutation);
        this.registerRecipeHandle(registry, TraitRecipe.class, AltarTraitRecipeWrapper::new, idAltarTrait);
        this.registerRecipeHandle(registry, ConstellationRecipe.class, AltarConstellationRecipeWrapper::new, idAltarConstellation);
        this.registerRecipeHandle(registry, AttunementRecipe.class, AltarAttunementRecipeWrapper::new, idAltarAttunement);
        this.registerRecipeHandle(registry, DiscoveryRecipe.class, AltarDiscoveryRecipeWrapper::new, idAltarDiscovery);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksAS.blockWell), new String[]{idWell});
        registry.addRecipeCatalyst((Object)BlockMachine.MachineType.GRINDSTONE.asStack(), new String[]{idGrindstone});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksAS.starlightInfuser), new String[]{idInfuser});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksAS.lens), new String[]{idTransmutation});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksAS.lensPrism), new String[]{idTransmutation});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_1.ordinal()), new String[]{idAltarDiscovery});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_2.ordinal()), new String[]{idAltarAttunement});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_3.ordinal()), new String[]{idAltarConstellation});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_4.ordinal()), new String[]{idAltarTrait});
        this.addTransferHandlers(rtr, jeiHelpers.recipeTransferHandlerHelper());
        registry.addRecipes(InfusionRecipeRegistry.recipes, idInfuser);
        registry.addRecipes(GrindstoneRecipeRegistry.getValidRecipes(), idGrindstone);
        registry.addRecipes(LightOreTransmutations.getRegisteredTransmutations(), idTransmutation);
        registry.addRecipes(WellLiquefaction.getRegisteredLiquefactions(), idWell);
        registry.addRecipes((Collection)AltarRecipeRegistry.recipes.get((Object)TileAltar.AltarLevel.DISCOVERY), idAltarDiscovery);
        registry.addRecipes((Collection)AltarRecipeRegistry.recipes.get((Object)TileAltar.AltarLevel.ATTUNEMENT), idAltarAttunement);
        registry.addRecipes((Collection)AltarRecipeRegistry.recipes.get((Object)TileAltar.AltarLevel.CONSTELLATION_CRAFT), idAltarConstellation);
        registry.addRecipes((Collection)AltarRecipeRegistry.recipes.get((Object)TileAltar.AltarLevel.TRAIT_CRAFT), idAltarTrait);
        registry.addRecipes((Collection)Lists.newArrayList((Object[])new AccessibleRecipeAdapater[]{RecipesAS.rCCParchment, RecipesAS.rRJournal, RecipesAS.rBlackMarbleRaw, RecipesAS.rBlackMarbleArch, RecipesAS.rBlackMarbleBricks, RecipesAS.rBlackMarbleChiseled, RecipesAS.rBlackMarbleEngraved, RecipesAS.rBlackMarblePillar, RecipesAS.rBlackMarbleRuned, RecipesAS.rMarbleArch, RecipesAS.rMarbleBricks, RecipesAS.rMarbleChiseled, RecipesAS.rMarbleEngraved, RecipesAS.rMarblePillar, RecipesAS.rMarbleRuned, RecipesAS.rMarbleStairs, RecipesAS.rMarbleSlab}), "minecraft.crafting");
        jeiRegistrationPhase = false;
    }

    private void addTransferHandlers(IRecipeTransferRegistry rtr, IRecipeTransferHandlerHelper trHelper) {
        if (!(stackHelper instanceof StackHelper)) {
            return;
        }
        StackHelper sHelper = (StackHelper)stackHelper;
        rtr.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarDiscovery>(ContainerAltarDiscovery.class, sHelper, trHelper, 9), idAltarDiscovery);
        rtr.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarAttunement>(ContainerAltarAttunement.class, sHelper, trHelper, 9), idAltarDiscovery);
        rtr.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarConstellation>(ContainerAltarConstellation.class, sHelper, trHelper, 9), idAltarDiscovery);
        rtr.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarTrait>(ContainerAltarTrait.class, sHelper, trHelper, 9), idAltarDiscovery);
        rtr.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarAttunement>(ContainerAltarAttunement.class, sHelper, trHelper, 13), idAltarAttunement);
        rtr.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarConstellation>(ContainerAltarConstellation.class, sHelper, trHelper, 13), idAltarAttunement);
        rtr.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarTrait>(ContainerAltarTrait.class, sHelper, trHelper, 13), idAltarAttunement);
        rtr.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarConstellation>(ContainerAltarConstellation.class, sHelper, trHelper, 21), idAltarConstellation);
        rtr.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarTrait>(ContainerAltarTrait.class, sHelper, trHelper, 21), idAltarConstellation);
        rtr.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarTrait>(ContainerAltarTrait.class, sHelper, trHelper, 25), idAltarTrait);
    }

    private void hideItems(IIngredientBlacklist blacklist) {
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemsAS.knowledgeFragment));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemsAS.fragmentCapsule));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlocksAS.blockFakeTree));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlocksAS.translucentBlock));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlocksAS.blockVanishing));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlocksAS.blockStructural));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlocksAS.blockPortalNode));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlocksAS.blockAltar, 1, 4));
        if (Mods.GEOLOSYS.isPresent() && Mods.ORESTAGES.isPresent()) {
            ModIntegrationGeolosys.hideJEIGeolosysSample(blacklist);
        }
    }

    private <T> void registerRecipeHandle(IModRegistry registry, Class<T> recipeClass, IRecipeWrapperFactory<T> factory, String categoryId) {
        factoryMap.put(recipeClass, new Tuple<IRecipeWrapperFactory<T>, String>(factory, categoryId));
        registry.handleRecipes(recipeClass, factory, categoryId);
    }

    public static boolean addRecipe(Object recipe) {
        Tuple<IRecipeWrapperFactory, String> factoryTuple = ModIntegrationJEI.findRecipeWrapperFor(recipe);
        if (factoryTuple != null) {
            RecipeChange change = new RecipeChange(((IRecipeWrapperFactory)factoryTuple.key).getRecipeWrapper(recipe), (String)factoryTuple.value, ModificationAction.ADDITION);
            if (recipeRegistry == null) {
                recipePrimer.add(change);
            } else {
                change.apply(ModIntegrationJEI.recipeRegistry);
            }
            return true;
        }
        unresolvedRecipes.add(new Tuple<Object, ModificationAction>(recipe, ModificationAction.ADDITION));
        return false;
    }

    public static boolean removeRecipe(Object recipe) {
        Tuple<IRecipeWrapperFactory, String> factoryTuple = ModIntegrationJEI.findRecipeWrapperFor(recipe);
        if (factoryTuple != null) {
            RecipeChange change = new RecipeChange(((IRecipeWrapperFactory)factoryTuple.key).getRecipeWrapper(recipe), (String)factoryTuple.value, ModificationAction.REMOVAL);
            if (recipeRegistry == null) {
                recipePrimer.add(change);
            } else {
                change.apply(ModIntegrationJEI.recipeRegistry);
            }
            return true;
        }
        unresolvedRecipes.add(new Tuple<Object, ModificationAction>(recipe, ModificationAction.REMOVAL));
        return false;
    }

    @Nullable
    private static Tuple<IRecipeWrapperFactory, String> findRecipeWrapperFor(Object recipe) {
        Class<?> recipeClass = recipe.getClass();
        Tuple<IRecipeWrapperFactory, String> factoryTuple = factoryMap.get(recipeClass);
        while (factoryTuple == null && !recipeClass.equals(Object.class)) {
            recipeClass = recipeClass.getSuperclass();
            factoryTuple = factoryMap.get(recipeClass);
        }
        return factoryTuple;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipeRegistry = jeiRuntime.getRecipeRegistry();
        for (RecipeChange recipeChange : recipePrimer) {
            recipeChange.apply(ModIntegrationJEI.recipeRegistry);
        }
        recipePrimer.clear();
        for (Tuple tuple : unresolvedRecipes) {
            switch ((ModificationAction)((Object)tuple.value)) {
                case ADDITION: {
                    ModIntegrationJEI.addRecipe(tuple.key);
                    break;
                }
                case REMOVAL: {
                    ModIntegrationJEI.removeRecipe(tuple.key);
                    break;
                }
            }
        }
        if (unresolvedRecipes.size() > 0) {
            AstralSorcery.log.warn("JEI Initialization Ended up with " + unresolvedRecipes.size() + " unresolvable crafttweaker recipes!");
        }
    }

    private static enum ModificationAction {
        ADDITION,
        REMOVAL;

    }

    private static class RecipeChange {
        private final IRecipeWrapper recipe;
        private final String category;
        private final ModificationAction action;

        private RecipeChange(IRecipeWrapper recipe, String category, ModificationAction action) {
            this.recipe = recipe;
            this.category = category;
            this.action = action;
        }

        private void apply(IRecipeRegistry recipeRegistry) {
            if (this.action == ModificationAction.ADDITION) {
                recipeRegistry.addRecipe(this.recipe, this.category);
            } else {
                recipeRegistry.removeRecipe(this.recipe, this.category);
            }
        }
    }
}

