/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event.listener;

import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.block.BlockMachine;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.RockCrystalBuffer;
import hellfirepvp.astralsorcery.common.event.BlockModifyEvent;
import hellfirepvp.astralsorcery.common.item.base.ISpecialInteractItem;
import hellfirepvp.astralsorcery.common.item.knowledge.ItemFragmentCapsule;
import hellfirepvp.astralsorcery.common.item.knowledge.ItemKnowledgeFragment;
import hellfirepvp.astralsorcery.common.item.tool.wand.ItemWand;
import hellfirepvp.astralsorcery.common.item.tool.wand.WandAugment;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.EnchantmentsAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktCraftingTableFix;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.registry.RegistryPotions;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.structure.array.BlockArray;
import hellfirepvp.astralsorcery.common.tile.TileFakeTree;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.struct.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.world.util.WorldEventNotifier;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventHandlerServer {
    private static final Random rand = new Random();

    @SubscribeEvent
    public void attachPlague(AttachCapabilitiesEvent<Entity> event) {
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        EntityItem ei = event.getItem();
        if (ei.func_92059_d().func_77973_b() instanceof ItemFragmentCapsule || ei.func_92059_d().func_77973_b() instanceof ItemKnowledgeFragment) {
            EntityPlayer pickingUp = event.getEntityPlayer();
            if (!pickingUp.func_130014_f_().field_72995_K) {
                String playerName = ei.func_145798_i();
                if (playerName == null) {
                    playerName = ei.func_145800_j();
                }
                if (playerName != null && !playerName.equals(pickingUp.func_70005_c_())) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onContainerOpen(PlayerContainerEvent.Open event) {
        if (event.getContainer() instanceof ContainerWorkbench && !event.getEntityPlayer().field_70170_p.field_72995_K && event.getEntityPlayer() instanceof EntityPlayerMP) {
            PacketChannel.CHANNEL.sendTo((IMessage)new PktCraftingTableFix(((ContainerWorkbench)event.getContainer()).field_178145_h), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDeath(LivingDeathEvent event) {
        if (event.getSource().func_76357_e()) {
            return;
        }
        if (this.phoenixProtect(event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    private boolean phoenixProtect(EntityLivingBase entity) {
        PotionEffect pe = entity.func_70660_b((Potion)RegistryPotions.potionCheatDeath);
        if (pe != null) {
            int level = pe.func_76458_c();
            this.phoenixEffects(entity, level);
            return true;
        }
        return false;
    }

    private void phoenixEffects(EntityLivingBase entity, int level) {
        entity.func_70606_j(Math.min(entity.func_110138_aP(), (float)(6 + level * 2)));
        entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 2, false, false));
        entity.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 500, 1, false, false));
        List others = entity.func_130014_f_().func_175647_a(EntityLivingBase.class, entity.func_174813_aQ().func_186662_g(3.0), e -> !e.field_70128_L && e != entity);
        for (EntityLivingBase lb : others) {
            lb.func_70015_d(16);
            lb.func_70653_a((Entity)entity, 2.0f, lb.field_70165_t - entity.field_70165_t, lb.field_70161_v - entity.field_70161_v);
        }
        PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.PHOENIX_PROC, new Vector3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
        PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(entity.field_70170_p, (Vec3i)entity.func_180425_c(), 32.0));
        MinecraftServer server = entity.func_184102_h();
        if (server != null) {
            server.func_152344_a(() -> entity.func_184589_d((Potion)RegistryPotions.potionCheatDeath));
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        ISpecialInteractItem i;
        IBlockState at = event.getWorld().func_180495_p(event.getPos());
        if (at.func_177230_c() instanceof BlockMachine && ((BlockMachine)at.func_177230_c()).handleSpecificActivateEvent(event)) {
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        ItemStack hand = event.getItemStack();
        if (hand.func_190926_b()) {
            return;
        }
        if (hand.func_77973_b() instanceof ISpecialInteractItem && (i = (ISpecialInteractItem)hand.func_77973_b()).needsSpecialHandling(event.getWorld(), event.getPos(), event.getEntityPlayer(), hand) && i.onRightClick(event.getWorld(), event.getPos(), event.getEntityPlayer(), event.getFace(), event.getHand(), hand)) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightClickLast(PlayerInteractEvent.RightClickBlock event) {
        IBlockState interacted;
        if (!event.getWorld().field_72995_K && (interacted = event.getWorld().func_180495_p(event.getPos())).func_177230_c() instanceof BlockWorkbench) {
            PktCraftingTableFix fix = new PktCraftingTableFix(event.getPos());
            PacketChannel.CHANNEL.sendTo((IMessage)fix, (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void onCraft(PlayerEvent.ItemCraftedEvent event) {
        if (event.player.func_184102_h() != null) {
            ResearchManager.informCraftingGridCompletion(event.player, event.crafting);
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer pl;
        if (Config.giveJournalFirst && !ResearchManager.getProgress(pl = event.player).didReceiveTome()) {
            pl.field_71071_by.func_70441_a(new ItemStack((Item)ItemsAS.journal));
        }
        if (event.player instanceof EntityPlayerMP) {
            ResearchManager.loadPlayerKnowledge((EntityPlayerMP)event.player);
            ResearchManager.savePlayerKnowledge((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)new WorldEventNotifier());
        GameRules rules = event.getWorld().func_82736_K();
        if (!rules.func_82765_e("astralSorceryIgnoreSkyCheck")) {
            rules.func_180262_a("astralSorceryIgnoreSkyCheck", "false", GameRules.ValueType.BOOLEAN_VALUE);
        }
    }

    @SubscribeEvent
    public void onChange(BlockModifyEvent event) {
        IBlockState oldState;
        if (event.getWorld().field_72995_K || !event.getChunk().func_177419_t()) {
            return;
        }
        if (!Loader.instance().hasReachedState(LoaderState.SERVER_ABOUT_TO_START)) {
            return;
        }
        BlockPos at = event.getPos();
        WorldNetworkHandler.getNetworkHandler(event.getWorld()).informBlockChange(at);
        if (event.getNewBlock().equals(Blocks.field_150462_ai) && !event.getOldBlock().equals(Blocks.field_150462_ai)) {
            WorldNetworkHandler.getNetworkHandler(event.getWorld()).attemptAutoLinkTo(at);
        }
        if (event.getOldBlock().equals(Blocks.field_150462_ai) && !event.getNewBlock().equals(Blocks.field_150462_ai)) {
            WorldNetworkHandler.getNetworkHandler(event.getWorld()).removeAutoLinkTo(at);
        }
        if (event.getNewBlock().equals(BlocksAS.blockAltar) && !event.getOldBlock().equals(BlocksAS.blockAltar)) {
            WorldNetworkHandler.getNetworkHandler(event.getWorld()).attemptAutoLinkTo(at);
        }
        if (event.getOldBlock().equals(BlocksAS.blockAltar) && !event.getNewBlock().equals(BlocksAS.blockAltar)) {
            WorldNetworkHandler.getNetworkHandler(event.getWorld()).removeAutoLinkTo(at);
        }
        if (event.getOldBlock().equals(BlocksAS.customOre) && ((BlockCustomOre.OreType)((Object)(oldState = event.getOldState()).func_177229_b(BlockCustomOre.ORE_TYPE))).equals((Object)BlockCustomOre.OreType.ROCK_CRYSTAL)) {
            ((RockCrystalBuffer)WorldCacheManager.getOrLoadData(event.getWorld(), WorldCacheManager.SaveKey.ROCK_CRYSTAL)).removeOre(event.getPos());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreak(BlockEvent.BreakEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        BlockPos at = event.getPos();
        Tuple<EnumHand, ItemStack> heldStack = MiscUtils.getMainOrOffHand((EntityLivingBase)event.getPlayer(), ItemsAS.wand, stack -> ItemWand.getAugment(stack) != null);
        if (heldStack != null && ItemWand.getAugment((ItemStack)heldStack.value) == WandAugment.EVORSIO && rand.nextFloat() < Config.evorsioEffectChance) {
            World w = event.getWorld();
            IBlockState stateAt = w.func_180495_p(at);
            BlockArray foundBlocks = BlockDiscoverer.searchForBlocksAround(w, at, 2, (world, pos, state) -> pos.func_177956_o() >= event.getPlayer().func_180425_c().func_177956_o() && state.equals(stateAt) && state.func_185887_b(world, pos) >= 0.0f && world.func_175625_s(pos) == null && !world.func_175623_d(pos) && world.func_180495_p(pos).func_177230_c().canHarvestBlock((IBlockAccess)world, pos, event.getPlayer()));
            for (BlockPos pos2 : foundBlocks.getPattern().keySet()) {
                IBlockState atState = w.func_180495_p(pos2);
                if (!w.func_175656_a(pos2, BlocksAS.blockFakeTree.func_176223_P())) continue;
                TileFakeTree tt = MiscUtils.getTileAt((IBlockAccess)w, pos2, TileFakeTree.class, true);
                if (tt != null) {
                    tt.setupTile(event.getPlayer(), event.getPlayer().func_184614_ca(), atState);
                    continue;
                }
                w.func_175656_a(pos2, atState);
            }
            if (foundBlocks.getPattern().containsKey(at)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        ItemStack main;
        if (event.getHarvester() != null && !event.isSilkTouching() && !(main = event.getHarvester().func_184614_ca()).func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsAS.enchantmentScorchingHeat, (ItemStack)main) > 0) {
            int fortuneLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)main);
            NonNullList drops = NonNullList.func_191196_a();
            event.getDrops().clear();
            event.getState().func_177230_c().getDrops(drops, (IBlockAccess)event.getWorld(), event.getPos(), event.getState(), fortuneLvl);
            for (ItemStack stack : drops) {
                ItemStack out = FurnaceRecipes.func_77602_a().func_151395_a(stack);
                if (!out.func_190926_b()) {
                    ItemStack furnaced = ItemUtils.copyStackWithSize(out, 1);
                    event.getDrops().add(furnaced);
                    furnaced.func_77980_a(event.getWorld(), event.getHarvester(), 1);
                    FMLCommonHandler.instance().firePlayerSmeltedEvent(event.getHarvester(), furnaced);
                    if (fortuneLvl <= 0 || out.func_77973_b() instanceof ItemBlock) continue;
                    for (int i = 0; i < fortuneLvl; ++i) {
                        if (!(rand.nextFloat() < 0.5f)) continue;
                        event.getDrops().add(ItemUtils.copyStackWithSize(out, 1));
                    }
                    continue;
                }
                event.getDrops().add(stack);
            }
        }
    }
}

