/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import java.util.Collection;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgressGatedPerk
extends AbstractPerk {
    private BiFunction<EntityPlayer, PlayerProgress, Boolean> unlockFunction = (player, progress) -> true;

    public ProgressGatedPerk(String name, int x, int y) {
        super(name, x, y);
    }

    public ProgressGatedPerk(ResourceLocation name, int x, int y) {
        super(name, x, y);
    }

    public void setRequireDiscoveredConstellation(IConstellation cst) {
        this.addResearchPreRequisite((player, progress) -> progress.hasConstellationDiscovered(cst));
    }

    public void addRequireProgress(ResearchProgression progression) {
        this.addResearchPreRequisite((player, progress) -> progress.getResearchProgression().contains((Object)progression));
    }

    public void addRequireTier(ProgressionTier tier) {
        this.addResearchPreRequisite((player, progress) -> progress.getTierReached().isThisLaterOrEqual(tier));
    }

    public void addResearchPreRequisite(BiFunction<EntityPlayer, PlayerProgress, Boolean> unlockFunction) {
        BiFunction<EntityPlayer, PlayerProgress, Boolean> prev = this.unlockFunction;
        this.unlockFunction = (player, progress) -> (Boolean)prev.apply((EntityPlayer)player, (PlayerProgress)progress) != false && (Boolean)unlockFunction.apply((EntityPlayer)player, (PlayerProgress)progress) != false;
        this.disableToltipCaching();
    }

    @Override
    public boolean mayUnlockPerk(PlayerProgress progress, EntityPlayer player) {
        if (!this.canSee(player, progress)) {
            return false;
        }
        return super.mayUnlockPerk(progress, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addLocalizedTooltip(Collection<String> tooltip) {
        if (!this.canSeeClient()) {
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"perk.info.missing_progress", (Object[])new Object[0]));
            return false;
        }
        return super.addLocalizedTooltip(tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean canSeeClient() {
        return this.canSee((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT);
    }

    public final boolean canSee(EntityPlayer player, Side side) {
        PlayerProgress prog = ResearchManager.getProgress(player, side);
        if (prog.isValid()) {
            return this.canSee(player, prog);
        }
        return false;
    }

    public final boolean canSee(EntityPlayer player, PlayerProgress progress) {
        return this.unlockFunction.apply(player, progress);
    }

    @Override
    protected void applyPerkLogic(EntityPlayer player, Side side) {
    }

    @Override
    protected void removePerkLogic(EntityPlayer player, Side side) {
    }
}

