/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.charger;

import cofh.core.inventory.ComparableItemStackNBT;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiCharger;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.charger.ChargerRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.ChargerManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ChargerRecipeCategory
extends BaseRecipeCategory<ChargerRecipeWrapper> {
    public static boolean enable = true;
    protected IDrawableStatic progress;

    public static void register(IRecipeCategoryRegistration registry) {
        String category = "Plugins.JEI";
        if (!(enable = ThermalExpansion.CONFIG_CLIENT.get(category, "Machine.Charger", enable))) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChargerRecipeCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(ChargerRecipeCategory.getRecipes(guiHelper), "thermalexpansion.charger");
        registry.addRecipeClickArea(GuiCharger.class, 79, 53, 18, 16, new String[]{"thermalexpansion.charger"});
        registry.addRecipeCatalyst((Object)BlockMachine.machineCharger, new String[]{"thermalexpansion.charger"});
    }

    public static List<ChargerRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<ChargerRecipeWrapper> recipes = new ArrayList<ChargerRecipeWrapper>();
        for (ChargerManager.ChargerRecipe recipe : ChargerManager.getRecipeList()) {
            recipes.add(new ChargerRecipeWrapper(guiHelper, recipe));
        }
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof IEnergyContainerItem)) continue;
            try {
                HashSet<ComparableItemStackNBT> processedStacks = new HashSet<ComparableItemStackNBT>();
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(item.func_77640_w(), list);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)item;
                    ItemStack chargable = (ItemStack)iterator.next();
                    int maxEnergyStored = energyContainerItem.getMaxEnergyStored(chargable);
                    if (maxEnergyStored == 0 || energyContainerItem.receiveEnergy(chargable, Integer.MAX_VALUE, true) <= 0) continue;
                    ItemStack input = chargable.func_77946_l();
                    ItemStack output = chargable.func_77946_l();
                    energyContainerItem.extractEnergy(input, Integer.MAX_VALUE, false);
                    energyContainerItem.receiveEnergy(output, Integer.MAX_VALUE, false);
                    if (!processedStacks.add(new ComparableItemStackNBT(input))) continue;
                    ChargerManager.ChargerRecipe recipe = new ChargerManager.ChargerRecipe(input, output, maxEnergyStored);
                    recipes.add(new ChargerRecipeWrapper(guiHelper, recipe));
                }
            }
            catch (Exception e) {
                ThermalExpansion.LOG.error("Exception thrown while getting Charger recipes.", (Throwable)e);
            }
        }
        return recipes;
    }

    public ChargerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiCharger.TEXTURE, 62, 11, 88, 62, 0, 0, 16, 60);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.charger.name");
        this.progress = Drawables.getDrawables(guiHelper).getScale(6);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.charger";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 34, 43);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, ChargerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 33, 23);
        guiItemStacks.init(1, false, 78, 23);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)outputs.get(0));
    }
}

