/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.inventorygenerators.common.generators;

import com.kjmaster.inventorygenerators.InventoryGenerators;
import com.kjmaster.inventorygenerators.common.generators.ItemInventoryGenerator;
import com.kjmaster.kjlib.utils.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemInvOverclockedGen
extends ItemInventoryGenerator {
    public ItemInvOverclockedGen() {
        super("inv_overclocked_gen");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.invgens.overclocked"));
        this.addMoreInformation(stack, tooltip);
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
    }

    @Override
    public int calculateTime(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return (int)Math.ceil(TileEntityFurnace.func_145952_a((ItemStack)stack) / 4000) + 1;
        }
        return 0;
    }

    @Override
    public int calculatePower(ItemStack stack) {
        int minSend = TileEntityFurnace.func_145952_a((ItemStack)this.getFuel(stack)) < 4000 ? TileEntityFurnace.func_145952_a((ItemStack)this.getFuel(stack)) : 4000;
        return Math.min(this.getMaxEnergyStored(stack) - this.getInternalEnergyStored(stack), minSend);
    }

    @Override
    public int getSend() {
        return 4000;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 1000000;
    }

    @Override
    public void initModel() {
        super.initModel();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        super.func_77659_a(world, player, hand);
        if (!player.func_70093_af()) {
            player.openGui((Object)InventoryGenerators.instance, 9, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        ItemStack stack = player.func_184586_b(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }
}

