/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.inventorygenerators.common.generators;

import com.kjmaster.inventorygenerators.InventoryGenerators;
import com.kjmaster.inventorygenerators.common.generators.ItemInventoryGenerator;
import com.kjmaster.kjlib.utils.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemInvHalitosisGen
extends ItemInventoryGenerator {
    public ItemInvHalitosisGen() {
        super("inv_halitosis_gen");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.invgens.halitosis"));
        this.addMoreInformation(stack, tooltip);
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        return stack.func_77973_b().equals(Items.field_185157_bK);
    }

    @Override
    public int calculateTime(ItemStack stack) {
        return stack.func_190926_b() ? 0 : 12000;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        final ModelResourceLocation onModel1 = new ModelResourceLocation(this.getRegistryName() + "_on1", "inventory");
        final ModelResourceLocation onModel2 = new ModelResourceLocation(this.getRegistryName() + "_on2", "inventory");
        final ModelResourceLocation onModel3 = new ModelResourceLocation(this.getRegistryName() + "_on3", "inventory");
        final ModelResourceLocation onModel4 = new ModelResourceLocation(this.getRegistryName() + "_on4", "inventory");
        final ModelResourceLocation offModel = new ModelResourceLocation(this.getRegistryName() + "_off", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{onModel1, onModel2, onModel3, onModel4, offModel});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                int burnTime = ItemInvHalitosisGen.this.getBurnTime(stack);
                if (ItemInvHalitosisGen.this.isOn(stack) && burnTime > 0) {
                    if (burnTime < 3000) {
                        return onModel1;
                    }
                    if (burnTime < 6000) {
                        return onModel2;
                    }
                    if (burnTime < 9000) {
                        return onModel3;
                    }
                    return onModel4;
                }
                return offModel;
            }
        });
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        super.func_77659_a(world, player, hand);
        if (!player.func_70093_af()) {
            player.openGui((Object)InventoryGenerators.instance, 6, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        ItemStack stack = player.func_184586_b(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }
}

