/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.extrarails.block.base;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowfacts.shadowmc.item.ItemModelProvider;

public abstract class BlockExtraRail
extends BlockRailBase
implements ItemModelProvider {
    public static final PropertyEnum<BlockRailBase.EnumRailDirection> SHAPE = PropertyEnum.func_177708_a((String)"shape", BlockRailBase.EnumRailDirection.class, dir -> dir == BlockRailBase.EnumRailDirection.NORTH_SOUTH || dir == BlockRailBase.EnumRailDirection.EAST_WEST);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    protected BlockExtraRail(boolean isPowered) {
        super(isPowered);
        this.func_149711_c(0.7f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public abstract void initItemModel();

    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    @Nonnull
    @Deprecated
    public abstract IBlockState func_176203_a(int var1);

    public abstract int func_176201_c(IBlockState var1);

    @Nonnull
    protected abstract BlockStateContainer func_180661_e();

    @Nonnull
    public IProperty<BlockRailBase.EnumRailDirection> func_176560_l() {
        return SHAPE;
    }

    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing facing = EnumFacing.func_176733_a((double)placer.field_70759_as);
        BlockRailBase.EnumRailDirection shape = facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? BlockRailBase.EnumRailDirection.NORTH_SOUTH : BlockRailBase.EnumRailDirection.EAST_WEST;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a(SHAPE, (Comparable)shape);
    }

    public boolean canMakeSlopes(IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected void propelMinecart(World world, BlockPos pos, IBlockState state, EntityMinecart minecart) {
        BlockRailBase.EnumRailDirection dir = this.getRailDirection((IBlockAccess)world, pos, state, minecart);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (dir == BlockRailBase.EnumRailDirection.EAST_WEST) {
            minecart.field_70159_w = facing == EnumFacing.EAST ? 0.2 : -0.2;
        } else if (dir == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
            minecart.field_70179_y = facing == EnumFacing.SOUTH ? 0.2 : -0.2;
        }
    }

    protected List<? extends EntityMinecart> findMinecarts(World world, BlockPos pos) {
        return world.func_72872_a(EntityMinecart.class, this.getDectectionBox(pos));
    }

    private AxisAlignedBB getDectectionBox(BlockPos pos) {
        return new AxisAlignedBB((double)((float)pos.func_177958_n() + 0.2f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.2f), (double)((float)(pos.func_177958_n() + 1) - 0.2f), (double)((float)(pos.func_177956_o() + 1) - 0.2f), (double)((float)(pos.func_177952_p() + 1) - 0.2f));
    }
}

