/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.hydrator;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.block.hydrator.BlockHydrator;
import com.lothrazar.cyclicmagic.block.hydrator.RecipeHydrate;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.liquid.FluidTankFixDesync;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityHydrator
extends TileEntityBaseMachineFluid
implements ITileRedstoneToggle,
ITickable {
    public static final int RECIPE_SIZE = 4;
    public static final int TANK_FULL = 10000;
    public static final int TIMER_FULL = 40;
    private int recipeIsLocked = 0;
    private InventoryCrafting crafting = new InventoryCrafting((Container)new ContainerDummyHydrator(), 2, 2);
    private RecipeHydrate currentRecipe;

    public TileEntityHydrator() {
        super(8);
        this.tank = new FluidTankFixDesync(10000, this);
        this.timer = 40;
        this.tank.setFluidAllowed(FluidRegistry.WATER);
        this.setSlotsForInsert(Arrays.asList(0, 1, 2, 3));
        this.setSlotsForExtract(Arrays.asList(4, 5, 6, 7));
        this.initEnergy(BlockHydrator.FUEL_COST);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174890_g() {
        return this.getFieldOrdinals().length;
    }

    public void func_73660_a() {
        this.currentRecipe = null;
        if (this.currentRecipe == null) {
            this.findMatchingRecipe();
            this.updateLockSlots();
        }
        if (!this.isRunning() || this.isInventoryFull(4)) {
            return;
        }
        if (this.currentRecipe == null || !this.updateEnergyIsBurning()) {
            return;
        }
        if (this.getCurrentFluidStackAmount() == 0) {
            return;
        }
        if (this.updateTimerIsZero() && this.tryProcessRecipe()) {
            this.timer = 40;
        }
    }

    private void updateLockSlots() {
        if (this.recipeIsLocked == 1) {
            if (this.currentRecipe != null) {
                ArrayList<Integer> slotsImport = new ArrayList<Integer>();
                for (int slot = 0; slot < 4; ++slot) {
                    if (this.func_70301_a(slot).func_190926_b()) continue;
                    slotsImport.add(slot);
                }
                this.setSlotsForInsert(slotsImport);
            }
        } else {
            this.setSlotsForInsert(Arrays.asList(0, 1, 2, 3));
        }
    }

    public boolean tryProcessRecipe() {
        if (this.currentRecipe != null && this.getCurrentFluidStackAmount() >= this.currentRecipe.getFluidCost() && this.inventoryHasRoom(4, this.currentRecipe.func_77571_b().func_77946_l())) {
            if (this.currentRecipe.tryPayCost(this, this.tank, this.recipeIsLocked == 1)) {
                this.sendOutputItem(this.currentRecipe.func_77571_b().func_77946_l());
            }
            return true;
        }
        return false;
    }

    private void findMatchingRecipe() {
        boolean allAir = true;
        for (int i = 0; i < 4; ++i) {
            allAir = allAir && this.func_70301_a(i).func_190926_b();
            this.crafting.func_70299_a(i, this.func_70301_a(i).func_77946_l());
        }
        if (allAir) {
            return;
        }
        for (RecipeHydrate rec : RecipeHydrate.recipes) {
            if (!rec.func_77569_a(this.crafting, this.field_145850_b)) continue;
            this.currentRecipe = rec;
        }
    }

    public void sendOutputItem(ItemStack itemstack) {
        for (int i = 4; i < 8; ++i) {
            if (itemstack.func_190926_b() || itemstack.func_77976_d() == 0) continue;
            itemstack = this.tryMergeStackIntoSlot(itemstack, i);
        }
        if (!itemstack.func_190926_b() && itemstack.func_77976_d() != 0) {
            UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.field_174879_c.func_177984_a(), itemstack);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("redstone", this.needsRedstone);
        compound.func_74768_a("rlock", this.recipeIsLocked);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
        this.recipeIsLocked = compound.func_74762_e("rlock");
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
            case RECIPELOCKED: {
                return this.recipeIsLocked;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case RECIPELOCKED: {
                this.recipeIsLocked = value % 2;
                this.updateLockSlots();
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public float getFillRatio() {
        return this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    public static class ContainerDummyHydrator
    extends Container {
        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }

    public static enum Fields {
        REDSTONE,
        TIMER,
        RECIPELOCKED;

    }
}

