/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.collector;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.data.ITileStackWrapper;
import com.lothrazar.cyclicmagic.gui.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.gui.core.StackWrapper;
import com.lothrazar.cyclicmagic.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.util.UtilShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileEntityVacuum
extends TileEntityBaseMachineInvo
implements ITileStackWrapper,
ITickable,
ITileRedstoneToggle,
ITilePreviewToggle {
    private NonNullList<StackWrapper> stacksWrapped = NonNullList.func_191197_a((int)10, (Object)new StackWrapper());
    private static final int VRADIUS = 2;
    private static final int MAX_SIZE = 9;
    public static final int TIMER_FULL = 20;
    public static final int ROWS = 4;
    public static final int COLS = 9;
    private int timer = 0;
    private int needsRedstone = 1;
    private int renderParticles = 0;
    private int size = 4;

    public TileEntityVacuum() {
        super(36);
        this.setSetRenderGlobally(true);
        this.setSlotsForExtract(0, 36);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.updateTimerIsZero()) {
            return;
        }
        this.updateCollection();
    }

    private void updateCollection() {
        BlockPos center = this.getTargetCenter();
        AxisAlignedBB region = new AxisAlignedBB(center).func_72321_a((double)this.size, 2.0, (double)this.size).func_72321_a((double)(-1 * this.size), -2.0, (double)(-1 * this.size));
        List items = this.func_145831_w().func_72872_a(EntityItem.class, region);
        if (items == null) {
            return;
        }
        for (EntityItem itemOnGround : items) {
            this.processItemOnGround(itemOnGround);
        }
    }

    private void processItemOnGround(EntityItem itemOnGround) {
        if (!this.canPickup(itemOnGround)) {
            return;
        }
        final ItemStack contained = itemOnGround.func_92059_d();
        ArrayList<ItemStack> toDrop = UtilInventoryTransfer.dumpToIInventory((List<ItemStack>)new ArrayList<ItemStack>(){
            {
                this.add(contained);
            }
        }, this, 0, 36);
        if (toDrop.size() > 0) {
            itemOnGround.func_92058_a(toDrop.get(0));
        } else {
            itemOnGround.func_184174_b(false);
            itemOnGround.func_70106_y();
        }
    }

    private List<ItemStack> getFilterNonempty() {
        ArrayList<ItemStack> filt = new ArrayList<ItemStack>();
        for (StackWrapper wrap : this.stacksWrapped) {
            if (wrap.isEmpty()) continue;
            filt.add(wrap.getStack().func_77946_l());
        }
        return filt;
    }

    private boolean canPickup(EntityItem itemOnGround) {
        if (itemOnGround.field_70128_L) {
            return false;
        }
        List<ItemStack> filt = this.getFilterNonempty();
        if (filt.size() == 0) {
            return true;
        }
        for (ItemStack f : filt) {
            if (!f.func_185136_b(itemOnGround.func_92059_d())) continue;
            return true;
        }
        return false;
    }

    private BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.size + 1);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        this.writeStackWrappers(this.stacksWrapped, tags);
        tags.func_74768_a("Timer", this.timer);
        tags.func_74768_a("redstone", this.needsRedstone);
        tags.func_74768_a("render", this.renderParticles);
        tags.func_74768_a("size", this.size);
        return super.func_189515_b(tags);
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readStackWrappers(this.stacksWrapped, tags);
        this.timer = tags.func_74762_e("Timer");
        this.needsRedstone = tags.func_74762_e("redstone");
        this.renderParticles = tags.func_74762_e("render");
        this.size = tags.func_74762_e("size");
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case SIZE: {
                return this.size;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value % 2;
                break;
            }
            case SIZE: {
                if (value > 9) {
                    value = 0;
                }
                this.size = value;
            }
        }
    }

    @Override
    public List<BlockPos> getShape() {
        BlockPos bottmCenter = this.getTargetCenter().func_177967_a(EnumFacing.DOWN, 2);
        return UtilShape.repeatShapeByHeight(UtilShape.squareHorizontalHollow(bottmCenter, this.size), 4);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.func_174887_a_(Fields.RENDERPARTICLES.ordinal()) == 1;
    }

    @Override
    public void toggleNeedsRedstone() {
        this.needsRedstone = (this.needsRedstone + 1) % 2;
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public StackWrapper getStackWrapper(int i) {
        return (StackWrapper)this.stacksWrapped.get(i);
    }

    @Override
    public void setStackWrapper(int i, StackWrapper stack) {
        this.stacksWrapped.set(i, (Object)stack);
    }

    @Override
    public int getWrapperCount() {
        return this.stacksWrapped.size();
    }

    public static enum Fields {
        TIMER,
        RENDERPARTICLES,
        REDSTONE,
        SIZE;

    }
}

