/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.cablewireless.fluid;

import com.lothrazar.cyclicmagic.block.cablewireless.ILaserTarget;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.item.location.ItemLocation;
import com.lothrazar.cyclicmagic.liquid.FluidTankFixDesync;
import com.lothrazar.cyclicmagic.util.RenderUtil;
import com.lothrazar.cyclicmagic.util.UtilFluid;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileCableFluidWireless
extends TileEntityBaseMachineFluid
implements ITickable,
ILaserTarget,
ITileRedstoneToggle {
    public static final int TRANSFER_FLUID_PER_TICK = 500;
    public static final int TANK_FULL = 10000;
    public static final int MAX_TRANSFER = 1000;
    public static final int SLOT_COUNT = 9;
    List<Integer> slotList = IntStream.rangeClosed(0, 9).boxed().collect(Collectors.toList());
    private int transferRate = 500;

    public TileCableFluidWireless() {
        super(9);
        this.tank = new FluidTankFixDesync(10000, this);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TRANSFER_RATE: {
                return this.transferRate;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TRANSFER_RATE: {
                this.transferRate = value;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value % 2;
            }
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemLocation;
    }

    private BlockPosDim getTarget(int slot) {
        return ItemLocation.getPosition(this.func_70301_a(slot));
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        Collections.shuffle(this.slotList);
        for (int slot : this.slotList) {
            this.outputFluid(slot);
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone == 1 ? 0 : 1;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    private boolean isTargetValid(BlockPosDim target) {
        return target != null && target.getDimension() == this.getDimension() && this.field_145850_b.func_175707_a(target.toBlockPos(), target.toBlockPos().func_177984_a());
    }

    private void outputFluid(int slot) {
        BlockPosDim dim = this.getTarget(slot);
        if (this.isTargetValid(dim)) {
            UtilFluid.tryFillPositionFromTank(this.field_145850_b, dim.toBlockPos(), null, this.tank, 500);
        }
    }

    @Override
    public boolean isVisible() {
        return this.renderParticles == 1;
    }

    @Override
    public RenderUtil.LaserConfig getTarget() {
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.transferRate = compound.func_74762_e("transferRate");
        this.needsRedstone = compound.func_74762_e("redstone");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("transferRate", this.transferRate);
        compound.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(compound);
    }

    public static enum Fields {
        REDSTONE,
        TRANSFER_RATE,
        RENDERPARTICLES;

    }
}

