/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.tile;

import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import shadows.plants2.util.ColorToPotionUtil;

public class TileBrewingCauldron
extends TileEntity {
    public static final String C = "colors";
    public static final String W1 = "wart1";
    public static final String W2 = "wart2";
    public static final String WL = "water_level";
    public static final String BE = "being_extracted";
    public static final String G = "gunpowder";
    public static final String DB = "dragon_breath";
    public static final ItemStack EMPTYNBT = new ItemStack((Item)null);
    protected EnumDyeColor[] colors = new EnumDyeColor[6];
    protected boolean hasFirstWart = false;
    protected boolean hasSecondWart = false;
    protected int waterLevel = 0;
    protected boolean beingExtracted = false;
    protected boolean gunpowder = false;
    protected boolean dragBreath = false;
    protected ItemStack generatedPotion = EMPTYNBT;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.colors = ColorToPotionUtil.intsToColorArray(tag.func_74759_k(C));
        this.hasFirstWart = tag.func_74767_n(W1);
        this.hasSecondWart = tag.func_74767_n(W2);
        this.waterLevel = tag.func_74762_e(WL);
        this.beingExtracted = tag.func_74767_n(BE);
        this.gunpowder = tag.func_74767_n(G);
        this.dragBreath = tag.func_74767_n(DB);
        this.generatedPotion = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_74779_i("item"))), 1, tag.func_74762_e("meta"));
        this.generatedPotion.func_77982_d(tag.func_74775_l("stack_nbt"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74783_a(C, ColorToPotionUtil.colorsToIntArray(this.colors));
        tag.func_74757_a(W1, this.hasFirstWart);
        tag.func_74757_a(W2, this.hasSecondWart);
        tag.func_74768_a(WL, this.waterLevel);
        tag.func_74757_a(BE, this.beingExtracted);
        tag.func_74778_a("item", this.generatedPotion.func_77973_b().getRegistryName().toString());
        tag.func_74768_a("meta", this.generatedPotion.func_77960_j());
        tag.func_74782_a("stack_nbt", (NBTBase)this.generatedPotion.func_77978_p());
        tag.func_74757_a(G, this.gunpowder);
        tag.func_74757_a(DB, this.dragBreath);
        return tag;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(this.waterLevel)), 3);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 150, this.func_189517_E_());
    }

    public void setColor(int index, EnumDyeColor color) {
        if (index < 0 || index > 5) {
            throw new ArrayIndexOutOfBoundsException("The colors array has a size of 6");
        }
        this.colors[index] = color;
        this.func_70296_d();
    }

    public void setFirstWart(boolean set) {
        this.hasFirstWart = set;
        this.func_70296_d();
    }

    public void setSecondWart(boolean set) {
        this.hasSecondWart = set;
        this.func_70296_d();
    }

    public void setWaterLevel(int level) {
        this.waterLevel = level;
        this.func_70296_d();
    }

    public void setExtracting(boolean set) {
        this.beingExtracted = set;
        this.func_70296_d();
    }

    public void setDragBreath(boolean set) {
        this.dragBreath = set;
        this.func_70296_d();
    }

    public void setGunpowder(boolean set) {
        this.gunpowder = set;
        this.func_70296_d();
    }

    public void setPotion(ItemStack stack) {
        this.generatedPotion = stack;
        this.func_70296_d();
    }

    public boolean isBeingExtracted() {
        return this.beingExtracted;
    }

    public EnumDyeColor[] getColors() {
        return this.colors;
    }

    public boolean hasMaxWater() {
        return this.waterLevel == 3;
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public boolean hasFirstWart() {
        return this.hasFirstWart;
    }

    public boolean hasNetherWart() {
        return this.hasFirstWart && this.hasSecondWart;
    }

    public Item getPotionItem() {
        if (this.gunpowder) {
            return Items.field_185155_bH;
        }
        if (this.dragBreath) {
            return Items.field_185156_bI;
        }
        return Items.field_151068_bn;
    }

    public ItemStack getPotion() {
        return this.generatedPotion.func_77946_l();
    }

    public void reset() {
        this.colors = new EnumDyeColor[6];
        this.hasFirstWart = false;
        this.hasSecondWart = false;
        this.waterLevel = 0;
        this.beingExtracted = false;
        this.generatedPotion = EMPTYNBT;
        this.gunpowder = false;
        this.dragBreath = false;
        this.func_70296_d();
    }

    static {
        EMPTYNBT.func_77982_d(new NBTTagCompound());
    }
}

