/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.item;

import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import shadows.placebo.client.IHasModel;
import shadows.plants2.Plants2;
import shadows.plants2.block.BlockEnumCrop;
import shadows.plants2.data.PlantConstants;

public class ItemSeed<E extends Enum<E>>
extends ItemSeeds
implements IHasModel {
    private EnumPlantType type;
    private IBlockState crop = null;
    private String cropName;
    private E cropVariant;

    public ItemSeed(String name, EnumPlantType type, String blockName, E variant) {
        super(null, null);
        this.type = type;
        this.cropName = blockName;
        this.cropVariant = variant;
        this.setRegistryName(name);
        this.func_77655_b("plants2." + name);
        this.func_77637_a(PlantConstants.TAB);
        Plants2.INFO.getItemList().add((Object)this);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, itemstack) && state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)this) && world.func_175623_d(pos.func_177984_a())) {
            world.func_175656_a(pos.func_177984_a(), this.getPlant((IBlockAccess)world, pos));
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.type;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.crop == null ? (this.crop = this.defineCropState()) : this.crop;
    }

    private IBlockState defineCropState() {
        BlockEnumCrop b = (BlockEnumCrop)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(this.cropName));
        return b.getStateFor(this.cropVariant).func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(0));
    }
}

