/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.gui;

import com.corwinjv.mobtotems.blocks.ModBlocks;
import com.corwinjv.mobtotems.blocks.TotemType;
import com.corwinjv.mobtotems.gui.util;
import com.corwinjv.mobtotems.network.Network;
import com.corwinjv.mobtotems.network.SetKnifeMetaMessage;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.ForgeHooksClient;

public class CarvingSelectorGui
extends GuiScreen {
    private static int INTRO_UPDATES = 5;
    private static int ANGLE_OFFSET = 17;
    private int updates = 0;
    private boolean in = true;
    private TotemType selectedType = TotemType.NONE;

    public CarvingSelectorGui(int meta) {
        this.selectedType = TotemType.fromMeta(meta);
    }

    public TotemType getTypeHoveredOver(float centerX, float centerY, int mouseX, int mouseY) {
        TotemType typeHoveredOver = TotemType.NONE;
        for (TotemType type : TotemType.values()) {
            double maxToCheck;
            float baseAngle = 360 / TotemType.values().length;
            double angle = baseAngle * (float)type.getMeta() - (float)ANGLE_OFFSET;
            double mouseAngle = this.getMouseAngle(new Vec2f(centerX, centerY), new Vec2f((float)mouseX, (float)mouseY));
            double minToCheck = this.sanitizeDegree(angle - (double)(baseAngle / 2.0f));
            if (minToCheck > (maxToCheck = this.sanitizeDegree(angle + (double)(baseAngle / 2.0f)))) {
                minToCheck -= 360.0;
            }
            if (!(mouseAngle > minToCheck) || !(mouseAngle < maxToCheck)) continue;
            typeHoveredOver = type;
        }
        return typeHoveredOver;
    }

    public TotemType getTypeSelected() {
        return this.selectedType;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179098_w();
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2 - 8;
        TotemType typeHovered = this.getTypeHoveredOver(centerX, centerY, mouseX, mouseY);
        TotemType typeSelected = this.getTypeSelected();
        Item item = Item.func_150898_a((Block)ModBlocks.TOTEM_WOOD);
        for (TotemType type : TotemType.values()) {
            ItemStack stack = new ItemStack(item, 1, type.getMeta());
            float radius = Math.min((float)(this.updates * 20), 95.0f);
            float baseAngle = 360 / TotemType.values().length;
            double angle = baseAngle * (float)type.getMeta() - (float)ANGLE_OFFSET;
            angle = this.sanitizeDegree(angle);
            double x = (double)centerX + Math.cos(Math.toRadians(angle)) * (double)radius;
            double y = (double)centerY + Math.sin(Math.toRadians(angle)) * (double)radius;
            this.field_146297_k.field_71446_o.func_110577_a(util.getGuiResourceLocation("chargeable_bg.png"));
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x - 18.5), (double)(y - 18.5), (double)(90.0f + this.field_73735_i));
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            this.func_73729_b(0, 0, 0, 0, 32, 32);
            GlStateManager.func_179121_F();
            IBakedModel model = this.field_146297_k.func_175599_af().func_184393_a(stack, null, null);
            this.renderItemModel(stack, x, y, model, this.field_146297_k.func_175599_af());
            int unselectedColor = 0xFFFFFF;
            int selectedColor = 0xFFAA00;
            int hoveredColor = 0x55FFFF;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x - 25.0), (double)(y + 13.0), (double)(100.0f + this.field_73735_i));
            GlStateManager.func_179139_a((double)0.85, (double)0.85, (double)1.0);
            String text = I18n.func_74837_a((String)(stack.func_77973_b().func_77667_c(stack) + ".name"), (Object[])new Object[0]);
            int colorToPrint = unselectedColor;
            if (type == typeSelected) {
                colorToPrint = selectedColor;
            }
            if (type == typeHovered) {
                colorToPrint = hoveredColor;
            }
            this.field_146289_q.func_175063_a(text, 0.0f, 0.0f, colorToPrint);
            this.field_146289_q.func_175063_a("", 0.0f, 0.0f, unselectedColor);
            GlStateManager.func_179121_F();
        }
        if (this.updates >= INTRO_UPDATES) {
            this.field_146289_q.func_175063_a(I18n.func_74837_a((String)"mobtotems:gui.carving.leftclick", (Object[])new Object[0]), (float)(centerX - 50), (float)(centerY - 5), 0xFFFFFF);
            this.field_146289_q.func_175063_a(I18n.func_74837_a((String)"mobtotems:gui.carving.rightclick", (Object[])new Object[0]), (float)(centerX - 50), (float)(15 + centerY), 0xFFFFFF);
        }
        GlStateManager.func_179121_F();
    }

    public double getMouseAngle(Vec2f referencePoint, Vec2f mousePos) {
        Vec2f relativePos = new Vec2f(mousePos.field_189982_i - referencePoint.field_189982_i, mousePos.field_189983_j - referencePoint.field_189983_j);
        double degrees = Math.toDegrees(Math.atan2(relativePos.field_189983_j, relativePos.field_189982_i));
        return this.sanitizeDegree(degrees);
    }

    public double sanitizeDegree(double degree) {
        if (degree < 0.0) {
            degree += 360.0;
        }
        if (degree > 360.0) {
            degree -= 360.0;
        }
        return degree;
    }

    protected void renderItemModel(ItemStack stack, double x, double y, IBakedModel bakedmodel, RenderItem renderItem) {
        GlStateManager.func_179094_E();
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.field_146297_k.field_71446_o.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.setupGuiTransform((int)x, (int)y);
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        renderItem.func_180454_a(stack, bakedmodel);
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.field_146297_k.field_71446_o.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private void setupGuiTransform(int xPosition, int yPosition) {
        GlStateManager.func_179109_b((float)xPosition, (float)yPosition, (float)(100.0f + this.field_73735_i));
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)32.0f, (float)32.0f, (float)32.0f);
        GlStateManager.func_179145_e();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.in) {
            ++this.updates;
            if (this.updates > INTRO_UPDATES) {
                this.updates = INTRO_UPDATES;
            }
        } else {
            --this.updates;
            if (this.updates < 0) {
                this.updates = 0;
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            int centerX = this.field_146294_l / 2;
            int centerY = this.field_146295_m / 2 - 8;
            this.selectedType = this.getTypeHoveredOver(centerX, centerY, mouseX, mouseY);
            Network.sendToServer(new SetKnifeMetaMessage(this.selectedType.getMeta(), EnumHand.MAIN_HAND));
        }
        if (mouseButton == 0 || mouseButton == 1) {
            this.in = false;
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

